/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.junit5;

import io.bootique.cayenne.CayenneModule;
import io.bootique.cayenne.junit5.tester.CayenneRuntimeManager;
import io.bootique.cayenne.junit5.tester.CayenneTesterBootiqueHook;
import io.bootique.cayenne.junit5.tester.CayenneTesterBootiqueHookProvider;
import io.bootique.cayenne.junit5.tester.CommitCounter;
import io.bootique.cayenne.junit5.tester.QueryCounter;
import io.bootique.cayenne.junit5.tester.RelatedEntity;
import io.bootique.di.BQModule;
import io.bootique.di.Binder;
import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.scope.BQBeforeMethodCallback;
import io.bootique.junit5.scope.BQBeforeScopeCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CayenneTester
implements BQBeforeScopeCallback,
BQBeforeMethodCallback {
    private boolean refreshCayenneCaches = true;
    private boolean deleteBeforeEachTest = false;
    private boolean skipSchemaCreation = false;
    private Collection<Class<? extends Persistent>> entities;
    private Collection<Class<? extends Persistent>> entityGraphRoots;
    private boolean allTables;
    private Collection<String> tables;
    private Collection<String> tableGraphRoots;
    private Collection<RelatedEntity> relatedTables;
    private CayenneTesterBootiqueHook bootiqueHook = new CayenneTesterBootiqueHook().onInit(r -> this.resolveRuntimeManager((ServerRuntime)r)).onInit(r -> this.createSchema());
    private CayenneRuntimeManager runtimeManager;
    private CommitCounter commitCounter = new CommitCounter();
    private QueryCounter queryCounter = new QueryCounter();

    public static CayenneTester create() {
        return new CayenneTester();
    }

    protected CayenneTester() {
    }

    public CayenneTester onInit(Consumer<ServerRuntime> callback) {
        this.bootiqueHook.onInit(callback);
        return this;
    }

    public CayenneTester doNoRefreshCayenneCaches() {
        this.refreshCayenneCaches = false;
        return this;
    }

    public CayenneTester skipSchemaCreation() {
        this.skipSchemaCreation = true;
        return this;
    }

    public final CayenneTester allTables() {
        this.allTables = true;
        return this;
    }

    @SafeVarargs
    public final CayenneTester entities(Class<? extends Persistent> ... entities) {
        if (this.entities == null) {
            this.entities = new HashSet<Class<? extends Persistent>>();
        }
        Collections.addAll(this.entities, entities);
        return this;
    }

    @SafeVarargs
    public final CayenneTester entitiesAndDependencies(Class<? extends Persistent> ... entities) {
        if (this.entityGraphRoots == null) {
            this.entityGraphRoots = new HashSet<Class<? extends Persistent>>();
        }
        Collections.addAll(this.entityGraphRoots, entities);
        return this;
    }

    public CayenneTester tables(String ... tables) {
        if (this.tables == null) {
            this.tables = new HashSet<String>();
        }
        Collections.addAll(this.tables, tables);
        return this;
    }

    public CayenneTester tablesAndDependencies(String ... tables) {
        if (this.tableGraphRoots == null) {
            this.tableGraphRoots = new HashSet<String>();
        }
        Collections.addAll(this.tableGraphRoots, tables);
        return this;
    }

    public CayenneTester relatedTables(Class<? extends Persistent> entityType, Property<?> relationship) {
        if (this.relatedTables == null) {
            this.relatedTables = new HashSet<RelatedEntity>();
        }
        this.relatedTables.add(new RelatedEntity(entityType, relationship.getName()));
        return this;
    }

    public CayenneTester deleteBeforeEachTest() {
        this.deleteBeforeEachTest = true;
        return this;
    }

    public BQModule moduleWithTestHooks() {
        return this::configure;
    }

    protected void configure(Binder binder) {
        CayenneModule.extend((Binder)binder).addFilter((DataChannelFilter)this.commitCounter).addFilter((DataChannelFilter)this.queryCounter);
        binder.bind(CayenneTesterBootiqueHook.class).toProviderInstance((Provider)new CayenneTesterBootiqueHookProvider(this.bootiqueHook)).initOnStartup();
    }

    public ServerRuntime getRuntime() {
        return this.bootiqueHook.getRuntime();
    }

    protected CayenneRuntimeManager getRuntimeManager() {
        Assertions.assertNotNull((Object)this.runtimeManager, (String)"Cayenne runtime is not resolved. Called outside of test lifecycle?");
        return this.runtimeManager;
    }

    public String getTableName(Class<? extends Persistent> entity) {
        ObjEntity e = this.getRuntime().getDataDomain().getEntityResolver().getObjEntity(entity);
        if (e == null) {
            throw new IllegalStateException("Type is not mapped in Cayenne: " + entity);
        }
        return e.getDbEntity().getName();
    }

    public String getRelatedTableName(Class<? extends Persistent> entity, Property<?> relationship, int tableIndex) {
        EntityResolver entityResolver = this.getRuntime().getDataDomain().getEntityResolver();
        return new RelatedEntity(entity, relationship.getName()).getRelatedTable(entityResolver, tableIndex).getName();
    }

    public void assertCommitCount(int expected) {
        this.commitCounter.assertCount(expected);
    }

    public void assertQueryCount(int expected) {
        this.queryCounter.assertCount(expected);
    }

    protected void resolveRuntimeManager(ServerRuntime runtime) {
        this.runtimeManager = this.allTables ? CayenneRuntimeManager.builder(runtime.getDataDomain()).dbEntities(runtime.getDataDomain().getEntityResolver().getDbEntities()).build() : CayenneRuntimeManager.builder(runtime.getDataDomain()).entities(this.entities).entityGraphRoots(this.entityGraphRoots).tables(this.tables).tableGraphRoots(this.tableGraphRoots).relatedEntities(this.relatedTables).build();
    }

    protected void createSchema() {
        if (!this.skipSchemaCreation) {
            this.getRuntimeManager().createSchema();
        }
    }

    public void beforeScope(BQTestScope scope, ExtensionContext context) throws Exception {
        this.bootiqueHook.initIfNeeded();
    }

    public void beforeMethod(BQTestScope scope, ExtensionContext context) {
        if (this.refreshCayenneCaches) {
            this.getRuntimeManager().refreshCaches();
        }
        if (this.deleteBeforeEachTest) {
            this.getRuntimeManager().deleteData();
        }
        this.commitCounter.reset();
        this.queryCounter.reset();
    }
}

