/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.junit5.tester;

import io.bootique.cayenne.junit5.tester.CayenneRuntimeManagerBuilder;
import io.bootique.cayenne.junit5.tester.FilteredDataMap;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.util.DoNothingOperationObserver;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SQLTemplate;

public class CayenneRuntimeManager {
    private DataDomain domain;
    private Map<String, FilteredDataMap> managedEntitiesByNode;

    public static CayenneRuntimeManagerBuilder builder(DataDomain domain) {
        return new CayenneRuntimeManagerBuilder(domain);
    }

    protected CayenneRuntimeManager(DataDomain domain, Map<String, FilteredDataMap> managedEntitiesByNode) {
        this.domain = domain;
        this.managedEntitiesByNode = managedEntitiesByNode;
    }

    public void refreshCaches() {
        if (this.domain.getSharedSnapshotCache() != null) {
            this.domain.getSharedSnapshotCache().clear();
        }
        if (this.domain.getQueryCache() != null) {
            this.domain.getQueryCache().clear();
        }
    }

    public Map<String, FilteredDataMap> getManagedEntitiesByNode() {
        return this.managedEntitiesByNode;
    }

    public void deleteData() {
        this.managedEntitiesByNode.forEach(this::deleteData);
    }

    public void createSchema() {
        this.managedEntitiesByNode.forEach(this::createSchema);
    }

    protected void deleteData(String nodeName, FilteredDataMap map) {
        DataNode node = this.domain.getDataNode(nodeName);
        map.getEntitiesInDeleteOrder().forEach(e -> this.deleteData(node, (DbEntity)e));
    }

    protected void deleteData(DataNode node, DbEntity entity) {
        String name = node.getAdapter().getQuotingStrategy().quotedFullyQualifiedName(entity);
        String sql = "delete from " + name;
        SQLTemplate query = new SQLTemplate();
        query.setDefaultTemplate(sql);
        node.performQueries(Collections.singleton(query), (OperationObserver)new DoNothingOperationObserver());
    }

    protected void createSchema(String nodeName, DataMap map) {
        DataNode node = this.domain.getDataNode(nodeName);
        DbGenerator generator = new DbGenerator(node.getAdapter(), map, node.getJdbcEventLogger());
        generator.setShouldCreateTables(true);
        generator.setShouldDropTables(false);
        generator.setShouldCreateFKConstraints(true);
        generator.setShouldCreatePKSupport(true);
        generator.setShouldDropPKSupport(false);
        try {
            generator.runGenerator(node.getDataSource());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating schema for DataNode: " + node.getName(), e);
        }
    }
}

