/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.junit5.tester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.junit.jupiter.api.Assertions;

public class CayenneTesterBootiqueHook {
    private ServerRuntime runtime;
    private Collection<Consumer<ServerRuntime>> onInitCallbacks = new ArrayList<Consumer<ServerRuntime>>();
    private boolean callbacksPending = true;

    public boolean isInitialized() {
        return !this.callbacksPending;
    }

    public CayenneTesterBootiqueHook onInit(Consumer<ServerRuntime> callback) {
        if (!this.callbacksPending) {
            throw new IllegalStateException("Callbacks already processed");
        }
        this.onInitCallbacks.add(callback);
        return this;
    }

    protected void setRuntime(ServerRuntime runtime) {
        this.checkUnused(runtime);
        this.runtime = runtime;
    }

    private void checkUnused(ServerRuntime runtime) {
        if (this.runtime != null && this.runtime != runtime) {
            throw new IllegalStateException("ServerRuntime is already initialized. Likely this CayenneTester is already in connected to another BQRuntime. To fix this error use one CayenneTester per BQRuntime.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initIfNeeded() {
        if (this.callbacksPending) {
            CayenneTesterBootiqueHook cayenneTesterBootiqueHook = this;
            synchronized (cayenneTesterBootiqueHook) {
                if (this.callbacksPending) {
                    this.onInitCallbacks.forEach(c -> c.accept(this.runtime));
                    this.callbacksPending = false;
                    return true;
                }
            }
        }
        return false;
    }

    public ServerRuntime getRuntime() {
        Assertions.assertNotNull((Object)this.runtime, (String)"ServerRuntime is not initialized. Not connected to Bootique runtime?");
        return this.runtime;
    }
}

