/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.junit5.tester;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.query.Query;
import org.junit.jupiter.api.Assertions;

public class CommitCounter
implements DataChannelFilter {
    private AtomicInteger count = new AtomicInteger(0);

    public void init(DataChannel channel) {
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
        this.count.incrementAndGet();
        return filterChain.onSync(originatingContext, changes, syncType);
    }

    public void assertCount(int expectedCommits) {
        Assertions.assertEquals((int)expectedCommits, (int)this.count.get(), (String)"Unexpected number of Cayenne commits executed");
    }

    public void reset() {
        this.count.set(0);
    }
}

