/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.junit5.tester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;

public class FilteredDataMap
extends DataMap {
    private LinkedHashMap<String, DbEntity> orderedEntities;
    private List<DbEntity> entitiesInDeleteOrder;

    public FilteredDataMap(String mapName, LinkedHashMap<String, DbEntity> orderedEntities) {
        super(mapName);
        this.orderedEntities = orderedEntities;
    }

    public List<DbEntity> getEntitiesInDeleteOrder() {
        if (this.entitiesInDeleteOrder == null) {
            ArrayList<DbEntity> list = new ArrayList<DbEntity>(this.orderedEntities.values());
            Collections.reverse(list);
            this.entitiesInDeleteOrder = list;
        }
        return this.entitiesInDeleteOrder;
    }

    public Collection<DbEntity> getDbEntitiesInInsertOrder() {
        return this.orderedEntities.values();
    }

    public SortedMap<String, DbEntity> getDbEntityMap() {
        return new TreeMap<String, DbEntity>(this.orderedEntities);
    }

    public Collection<DbEntity> getDbEntities() {
        return this.getDbEntitiesInInsertOrder();
    }

    public DbEntity getDbEntity(String dbEntityName) {
        return this.orderedEntities.get(dbEntityName);
    }
}

