/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.junit5.tester;

import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

public class RelatedEntity {
    private Class<? extends Persistent> type;
    private String relationship;

    public RelatedEntity(Class<? extends Persistent> type, String relationship) {
        this.type = type;
        this.relationship = relationship;
    }

    public Class<? extends Persistent> getType() {
        return this.type;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public DbEntity getRelatedTable(EntityResolver resolver, int tableIndex) {
        ObjEntity entity = resolver.getObjEntity(this.type);
        if (entity == null) {
            throw new IllegalArgumentException("Not a Cayenne entity class: " + this.type.getName());
        }
        ObjRelationship flattened = entity.getRelationship(this.relationship);
        if (flattened == null) {
            throw new IllegalArgumentException("No relationship '" + this.relationship + "' in entity " + this.type.getName());
        }
        List path = flattened.getDbRelationships();
        if (path.size() < tableIndex + 1) {
            throw new IllegalArgumentException("Index " + tableIndex + " is out of bounds for relationship '" + this.relationship);
        }
        return ((DbRelationship)path.get(tableIndex)).getTargetEntity();
    }
}

