/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.kafka.client_0_8.consumer;

import io.bootique.kafka.client_0_8.consumer.OffsetReset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ConsumerConfig {
    private long zookeeperSessionTimeoutMs;
    private long zookeeperSyncTimeMs;
    private long autoCommitIntervalMs;
    private OffsetReset autoOffsetReset = OffsetReset.largest;
    private String group;

    public Map<String, String> createConsumerConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("auto.offset.reset", Objects.requireNonNull(this.autoOffsetReset).name());
        if (this.group != null) {
            props.put("group.id", this.group);
        }
        if (this.zookeeperSessionTimeoutMs > 0L) {
            props.put("zookeeper.session.timeout.ms", String.valueOf(this.zookeeperSessionTimeoutMs));
        }
        if (this.zookeeperSyncTimeMs > 0L) {
            props.put("zookeeper.sync.time.ms", String.valueOf(this.zookeeperSyncTimeMs));
        }
        if (this.autoCommitIntervalMs > 0L) {
            props.put("auto.commit.interval.ms", String.valueOf(this.autoCommitIntervalMs));
        }
        return props;
    }

    public void setAutoOffsetReset(OffsetReset autoOffsetReset) {
        this.autoOffsetReset = Objects.requireNonNull(autoOffsetReset);
    }

    public void setZookeeperSessionTimeoutMs(long zookeeperSessionTimeoutMs) {
        this.zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMs;
    }

    public void setZookeeperSyncTimeMs(long zookeeperSyncTimeMs) {
        this.zookeeperSyncTimeMs = zookeeperSyncTimeMs;
    }

    public void setAutoCommitIntervalMs(long autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public void setGroup(String group) {
        this.group = group;
    }
}

