/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.kafka.client_0_8.consumer;

import io.bootique.kafka.client_0_8.consumer.ConsumerConfig;
import io.bootique.kafka.client_0_8.consumer.ConsumerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.consumer.Consumer;
import kafka.javaapi.consumer.ConsumerConnector;

public class DefaultConsumerFactory
implements ConsumerFactory {
    private Map<String, Map<String, String>> configs;

    public DefaultConsumerFactory(Map<String, Map<String, String>> configs) {
        this.configs = configs;
    }

    @Override
    public ConsumerConnector newConsumerConnector() {
        return this.newConsumerConnector(this.getDefaultName(), null);
    }

    @Override
    public ConsumerConnector newConsumerConnector(String name) {
        return this.newConsumerConnector(name, null);
    }

    @Override
    public ConsumerConnector newConsumerConnector(ConsumerConfig configOverrides) {
        return this.newConsumerConnector(this.getDefaultName(), configOverrides);
    }

    @Override
    public ConsumerConnector newConsumerConnector(String name, ConsumerConfig configOverrides) {
        Properties mergedProps = new Properties();
        Map<String, String> config = this.configs.get(name);
        if (config != null) {
            mergedProps.putAll(config);
        }
        if (configOverrides != null) {
            mergedProps.putAll(configOverrides.createConsumerConfig());
        }
        return Consumer.createJavaConsumerConnector((kafka.consumer.ConsumerConfig)new kafka.consumer.ConsumerConfig(mergedProps));
    }

    public Collection<String> getConfigNames() {
        return Collections.unmodifiableCollection(this.configs.keySet());
    }

    private String getDefaultName() {
        Set<String> allNames = this.configs.keySet();
        switch (allNames.size()) {
            case 0: {
                throw new IllegalStateException("Kafka consumers are not configured");
            }
            case 1: {
                return (String)allNames.iterator().next();
            }
        }
        throw new IllegalStateException("Default Kafka consumer name ambiguity. More then one consumer is provided in configuration.");
    }
}

