/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.linkmove.v3;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.nhl.link.move.resource.FolderResourceResolver;
import com.nhl.link.move.resource.ResourceResolver;
import com.nhl.link.move.runtime.LmRuntime;
import com.nhl.link.move.runtime.LmRuntimeBuilder;
import com.nhl.link.move.runtime.connect.IConnectorFactory;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.linkmove.v3.LinkMoveBuilderCallback;
import io.bootique.linkmove.v3.resource.BQUrlResourceResolver;
import io.bootique.resource.FolderResourceFactory;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.cayenne.configuration.server.ServerRuntime;

@JsonIgnoreProperties(ignoreUnknown=true)
@BQConfig
public class LinkMoveFactory {
    private final ServerRuntime targetRuntime;
    private final Set<IConnectorFactory<?>> connectorFactories;
    private final Set<LinkMoveBuilderCallback> buildCallbacks;
    private FolderResourceFactory extractorsDir;

    @Inject
    public LinkMoveFactory(ServerRuntime targetRuntime, Set<IConnectorFactory<?>> connectorFactories, Set<LinkMoveBuilderCallback> buildCallbacks) {
        this.targetRuntime = targetRuntime;
        this.connectorFactories = connectorFactories;
        this.buildCallbacks = buildCallbacks;
    }

    public LmRuntime create() {
        ResourceResolver resolver = this.createResolver();
        LmRuntimeBuilder builder = LmRuntime.builder().withTargetRuntime(this.targetRuntime).extractorResolver(resolver);
        this.connectorFactories.forEach(arg_0 -> ((LmRuntimeBuilder)builder).connectorFactory(arg_0));
        this.buildCallbacks.forEach(c -> c.build(builder));
        return builder.build();
    }

    protected ResourceResolver createResolver() {
        FolderResourceFactory dir = this.extractorsDir != null ? this.extractorsDir : new FolderResourceFactory(".");
        return this.folderUrl(dir).map(this::crateFolderResolver).orElseGet(() -> new BQUrlResourceResolver(dir));
    }

    protected ResourceResolver crateFolderResolver(URL url) {
        try {
            return new FolderResourceResolver(new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Not a 'file:' URL: " + url, e);
        }
    }

    protected Optional<URL> folderUrl(FolderResourceFactory dir) {
        if (dir.getResourceId().startsWith("classpath:")) {
            return Optional.empty();
        }
        URL url = dir.getUrl();
        return "file".equals(url.getProtocol()) ? Optional.of(url) : Optional.empty();
    }

    @BQConfigProperty
    public void setExtractorsDir(FolderResourceFactory extractorsDir) {
        this.extractorsDir = extractorsDir;
    }
}

