/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.linkmove.v3.connector;

import com.nhl.link.move.runtime.connect.IConnectorFactory;
import com.nhl.link.move.runtime.jdbc.DataSourceConnector;
import com.nhl.link.move.runtime.jdbc.JdbcConnector;
import io.bootique.jdbc.DataSourceFactory;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;

public class JdbcConnectorFactory
implements IConnectorFactory<JdbcConnector> {
    private final DataSourceFactory dataSourceFactory;
    private final Set<String> knownNames;

    public JdbcConnectorFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.knownNames = new HashSet<String>(dataSourceFactory.allNames());
    }

    public Class<JdbcConnector> getConnectorType() {
        return JdbcConnector.class;
    }

    public Optional<JdbcConnector> createConnector(String id) {
        return this.connectorDataSource(id).map(ds -> new DataSourceConnector(id, ds));
    }

    Optional<DataSource> connectorDataSource(String id) {
        return this.knownNames.contains(id) ? Optional.of(this.dataSourceFactory.forName(id)) : Optional.empty();
    }
}

