/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.linkmove.v3.resource;

import com.nhl.link.move.LmRuntimeException;
import com.nhl.link.move.resource.ResourceResolver;
import io.bootique.resource.FolderResourceFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BQUrlResourceResolver
implements ResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BQUrlResourceResolver.class);
    private FolderResourceFactory baseFolder;

    public BQUrlResourceResolver(FolderResourceFactory baseFolder) {
        this.baseFolder = baseFolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Resources will be located relative to URL {}", (Object)baseFolder.getUrl());
        }
    }

    public Reader reader(String location) {
        URL url = this.baseFolder.getUrl(location);
        LOGGER.debug("Will read resource at URL {}", (Object)url);
        try {
            return new InputStreamReader(url.openStream());
        }
        catch (IOException e) {
            throw new LmRuntimeException("Error reading resource at URL " + url, (Throwable)e);
        }
    }
}

