/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.mvc.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheResolver;
import io.bootique.mvc.Template;
import io.bootique.mvc.renderer.RenderableTemplateCache;
import io.bootique.mvc.renderer.TemplateRenderer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;

public class MustacheTemplateRenderer
implements TemplateRenderer {
    private final RenderableTemplateCache templateCache;
    private final ThreadLocal<Template> templateContext;
    private final MustacheFactory mustacheFactory;

    public MustacheTemplateRenderer(RenderableTemplateCache templateCache) {
        this.templateCache = templateCache;
        this.templateContext = new ThreadLocal();
        this.mustacheFactory = new DefaultMustacheFactory((MustacheResolver)new ContextAwareMustacheResolver());
    }

    public void render(Writer out, Template template, Object rootModel) throws IOException {
        Mustache mustache = (Mustache)this.templateCache.get(template, this::compile);
        mustache.execute(out, rootModel).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mustache compile(Template template) {
        this.startContext(template);
        try {
            Reader reader = template.reader();
            Mustache mustache = this.mustacheFactory.compile(reader, template.getName());
            return mustache;
        }
        finally {
            this.endContext();
        }
    }

    private void startContext(Template template) {
        this.templateContext.set(template);
    }

    private void endContext() {
        this.templateContext.set(null);
    }

    class ContextAwareMustacheResolver
    implements MustacheResolver {
        ContextAwareMustacheResolver() {
        }

        public Reader getReader(String resourceName) {
            Template template = Objects.requireNonNull(MustacheTemplateRenderer.this.templateContext.get(), "No root template, called outside of compilation context");
            return template.reader(resourceName);
        }
    }
}

