/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.mvc;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.mvc.renderer.RenderableTemplateCache;
import io.bootique.mvc.resolver.DefaultTemplateResolver;
import io.bootique.resource.FolderResourceFactory;
import io.bootique.value.Duration;
import java.nio.charset.Charset;
import java.util.Objects;

@BQConfig(value="Configures MVC services")
public class MvcFactory {
    private FolderResourceFactory templateBase = new FolderResourceFactory("");
    private Charset templateEncoding = Charset.forName("UTF-8");
    private Duration templateTtl;

    public RenderableTemplateCache createRenderableTemplateCache() {
        return this.templateTtl != null ? RenderableTemplateCache.of(this.templateTtl.getDuration()) : RenderableTemplateCache.ofNoCache();
    }

    public DefaultTemplateResolver createResolver() {
        return new DefaultTemplateResolver(this.templateBase, this.templateEncoding);
    }

    @BQConfigProperty(value="Sets a base location of templates. Templates paths are built using the following formula: \"template_path = templateBase + resource_package_path + template_name_with_extension\".")
    public void setTemplateBase(FolderResourceFactory templateBase) {
        this.templateBase = Objects.requireNonNull(templateBase);
    }

    @BQConfigProperty(value="Sets template encoding. Default is UTF-8.")
    public void setTemplateEncoding(String templateEncoding) {
        this.templateEncoding = Charset.forName(Objects.requireNonNull(templateEncoding));
    }

    @BQConfigProperty(value="Sets template reload time interval. This controls template caching. By default is not set to anything, causing template reloading on every call")
    public void setTemplateTtl(Duration templateTtl) {
        this.templateTtl = templateTtl;
    }
}

