/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.mvc.renderer;

import io.bootique.mvc.Template;
import io.bootique.mvc.renderer.RenderableTemplateCache;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

class TtlCache
implements RenderableTemplateCache {
    private final long ttlMs;
    private final ConcurrentMap<String, CacheEntry> cache;

    public TtlCache(long ttlMs) {
        this.ttlMs = ttlMs;
        this.cache = new ConcurrentHashMap<String, CacheEntry>();
    }

    @Override
    public <T> T get(Template template, Function<Template, T> renderedTemplateMaker) {
        return this.cache.computeIfAbsent(template.getUrl().toExternalForm(), k -> new CacheEntry()).updateIfNeeded(template, renderedTemplateMaker);
    }

    class CacheEntry {
        private final Lock lock;
        volatile long expiresOn = System.currentTimeMillis() - 1L;
        volatile Object value;

        CacheEntry() {
            this.lock = new ReentrantLock();
        }

        <T> T updateIfNeeded(Template t, Function<Template, T> tMaker) {
            long expiredOn = this.expiresOn;
            return (T)(expiredOn >= System.currentTimeMillis() ? this.value : (this.value != null ? this.updateTryLock(expiredOn, t, tMaker) : this.updateLock(expiredOn, t, tMaker)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T updateLock(long expiredOn, Template t, Function<Template, T> tMaker) {
            this.lock.lock();
            try {
                T t2 = this.updateNoLocks(expiredOn, t, tMaker);
                return t2;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T updateTryLock(long expiredOn, Template t, Function<Template, T> tMaker) {
            if (!this.lock.tryLock()) {
                return (T)this.value;
            }
            try {
                T t2 = this.updateNoLocks(expiredOn, t, tMaker);
                return t2;
            }
            finally {
                this.lock.unlock();
            }
        }

        private <T> T updateNoLocks(long expiredOn, Template t, Function<Template, T> tMaker) {
            if (expiredOn == this.expiresOn) {
                this.value = Objects.requireNonNull(tMaker.apply(t));
                this.expiresOn = System.currentTimeMillis() + TtlCache.this.ttlMs;
            }
            return (T)this.value;
        }
    }
}

