/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.mvc.resolver;

import io.bootique.mvc.Template;
import io.bootique.resource.FolderResourceFactory;
import java.net.URL;
import java.nio.charset.Charset;

public class DefaultTemplate
implements Template {
    private final FolderResourceFactory base;
    private final String path;
    private final String name;
    private final Charset sourceEncoding;
    private volatile URL url;

    public DefaultTemplate(FolderResourceFactory base, String path, String name, Charset sourceEncoding) {
        this.name = name;
        this.base = base;
        this.path = path;
        this.sourceEncoding = sourceEncoding;
    }

    @Override
    public URL getUrl() {
        if (this.url == null) {
            String path = this.resourcePath(this.name);
            this.url = this.base.getUrl(path);
        }
        return this.url;
    }

    @Override
    public URL getUrl(String resourceName) {
        String path = this.resourcePath(resourceName);
        return this.base.getUrl(path);
    }

    @Override
    public Charset getEncoding() {
        return this.sourceEncoding;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String resourcePath(String resource) {
        String path = resource.startsWith("/") ? resource : this.path + resource;
        DefaultTemplate.checkPathWithinBounds(path);
        return path;
    }

    protected static void checkPathWithinBounds(String resourcePath) {
        if (resourcePath.length() < 2) {
            return;
        }
        int depth = 0;
        String normalizedPath = resourcePath.replace('\\', '/');
        for (String component : normalizedPath.split("/")) {
            if (component.length() <= 0) continue;
            if ("..".equals(component)) {
                if (--depth >= 0) continue;
                throw new RuntimeException("Path is outside the template base: " + resourcePath);
            }
            ++depth;
        }
    }
}

