/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.mvc.resolver;

import io.bootique.mvc.Template;
import io.bootique.mvc.resolver.DefaultTemplate;
import io.bootique.mvc.resolver.TemplateResolver;
import io.bootique.resource.FolderResourceFactory;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultTemplateResolver
implements TemplateResolver {
    private final Charset templateEncoding;
    private final FolderResourceFactory templateBase;
    private final ConcurrentMap<String, Template> cachedTemplates;

    public DefaultTemplateResolver(FolderResourceFactory templateBase, Charset templateEncoding) {
        this.templateBase = templateBase;
        this.templateEncoding = Objects.requireNonNull(templateEncoding, "Null templateEncoding");
        this.cachedTemplates = new ConcurrentHashMap<String, Template>();
    }

    @Override
    public Template resolve(String templateName, Class<?> viewType) {
        Package pkg = viewType.getPackage();
        String key = pkg != null ? pkg.getName() + templateName : templateName;
        return this.cachedTemplates.computeIfAbsent(key, k -> this.createTemplate(templateName, pkg));
    }

    private Template createTemplate(String templateName, Package pkg) {
        String path = pkg != null ? pkg.getName().replace('.', '/') + "/" : "";
        return new DefaultTemplate(this.templateBase, path, templateName, this.templateEncoding);
    }
}

