/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.mvc.renderer;

import io.bootique.mvc.Template;
import io.bootique.mvc.renderer.TemplateRenderer;
import io.bootique.mvc.renderer.TemplateRenderers;
import java.util.Map;

public class ByExtensionTemplateRenderers
implements TemplateRenderers {
    private final Map<String, TemplateRenderer> renderersByExtension;

    public ByExtensionTemplateRenderers(Map<String, TemplateRenderer> renderersByExtension) {
        this.renderersByExtension = renderersByExtension;
    }

    @Override
    public TemplateRenderer getRenderer(Template template) {
        String ext = this.getExtension(template.getName());
        TemplateRenderer renderer = this.renderersByExtension.get(ext);
        if (renderer == null) {
            throw new IllegalArgumentException("Unsupported template extension: " + ext + ", supported extensions: " + this.renderersByExtension.keySet());
        }
        return renderer;
    }

    String getExtension(String path) {
        int dot = path.lastIndexOf(46);
        if (dot <= 0 || dot == path.length() - 1) {
            throw new IllegalArgumentException("Path without extension: " + path);
        }
        return path.substring(dot);
    }
}

