/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.jr.ob.JSONComposer;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.JacksonJrExtension;
import com.fasterxml.jackson.jr.ob.PackageVersion;
import com.fasterxml.jackson.jr.ob.ValueIterator;
import com.fasterxml.jackson.jr.ob.api.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.api.ExtensionContext;
import com.fasterxml.jackson.jr.ob.api.MapBuilder;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterModifier;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterProvider;
import com.fasterxml.jackson.jr.ob.comp.CollectionComposer;
import com.fasterxml.jackson.jr.ob.comp.MapComposer;
import com.fasterxml.jackson.jr.ob.impl.JSONAsObjectCodec;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.fasterxml.jackson.jr.ob.impl.ValueReaderLocator;
import com.fasterxml.jackson.jr.ob.impl.ValueWriterLocator;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSON
implements Versioned {
    static final int DEFAULT_FEATURES = Feature.defaults();
    public static final int CACHE_FLAGS = Feature.cacheBreakers();
    public static final JSON std = new JSON();
    protected final JsonFactory _jsonFactory;
    protected final TreeCodec _treeCodec;
    protected final ValueReaderLocator _valueReaderLocator;
    protected final ValueWriterLocator _valueWriterLocator;
    protected final JSONReader _reader;
    protected final JSONWriter _writer;
    protected final int _features;
    protected final PrettyPrinter _prettyPrinter;

    public JSON() {
        this(new JsonFactory());
    }

    public JSON(JsonFactory jsonFactory) {
        this._features = DEFAULT_FEATURES;
        this._jsonFactory = jsonFactory;
        this._treeCodec = null;
        this._valueReaderLocator = ValueReaderLocator.blueprint(null, null);
        this._valueWriterLocator = ValueWriterLocator.blueprint(null, null);
        this._reader = this._defaultReader();
        this._writer = this._defaultWriter();
        this._prettyPrinter = null;
    }

    public JSON(Builder builder) {
        this._features = builder.featureMask();
        this._jsonFactory = builder.streamFactory();
        this._treeCodec = builder.treeCodec();
        ReaderWriterProvider readerWriterProvider = builder.readerWriterProvider();
        ReaderWriterModifier readerWriterModifier = builder.readerWriterModifier();
        ValueReaderLocator valueReaderLocator = ValueReaderLocator.blueprint(null, null);
        ValueWriterLocator valueWriterLocator = ValueWriterLocator.blueprint(null, null);
        if (readerWriterProvider != null) {
            valueReaderLocator = valueReaderLocator.with(readerWriterProvider);
            valueWriterLocator = valueWriterLocator.with(readerWriterProvider);
        }
        if (readerWriterModifier != null) {
            valueReaderLocator = valueReaderLocator.with(readerWriterModifier);
            valueWriterLocator = valueWriterLocator.with(readerWriterModifier);
        }
        this._valueReaderLocator = valueReaderLocator;
        this._valueWriterLocator = valueWriterLocator;
        this._reader = builder.jsonReader();
        this._writer = builder.jsonWriter();
        this._prettyPrinter = builder.prettyPrinter();
    }

    public static Builder builder() {
        return JSON.builder(new JsonFactory());
    }

    public static Builder builder(JsonFactory jsonFactory) {
        return new Builder(jsonFactory);
    }

    protected JSON(JSON jSON, int n, JsonFactory jsonFactory, TreeCodec treeCodec, JSONReader jSONReader, JSONWriter jSONWriter, PrettyPrinter prettyPrinter) {
        this._features = n;
        this._jsonFactory = jsonFactory;
        this._treeCodec = treeCodec;
        this._valueReaderLocator = jSON._valueReaderLocator;
        this._valueWriterLocator = jSON._valueWriterLocator;
        this._reader = jSONReader;
        this._writer = jSONWriter;
        this._prettyPrinter = prettyPrinter;
    }

    protected JSON(JSON jSON, ValueReaderLocator valueReaderLocator, ValueWriterLocator valueWriterLocator) {
        this._features = jSON._features;
        this._jsonFactory = jSON._jsonFactory;
        this._treeCodec = jSON._treeCodec;
        this._valueReaderLocator = valueReaderLocator;
        this._valueWriterLocator = valueWriterLocator;
        this._reader = jSON._reader;
        this._writer = jSON._writer;
        this._prettyPrinter = jSON._prettyPrinter;
    }

    protected JSONReader _defaultReader() {
        return new JSONReader(CollectionBuilder.defaultImpl(), MapBuilder.defaultImpl());
    }

    protected JSONWriter _defaultWriter() {
        return new JSONWriter();
    }

    public ObjectCodec asCodec() {
        return new JSONAsObjectCodec(this);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public JSON with(PrettyPrinter prettyPrinter) {
        if (this._prettyPrinter == prettyPrinter) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, this._reader, this._writer, prettyPrinter);
    }

    public JSON with(Feature feature, boolean bl) {
        int n = this._features;
        n = bl ? (n |= feature.mask()) : (n &= ~feature.mask());
        return this._with(n);
    }

    public JSON with(Feature ... featureArray) {
        int n = this._features;
        for (Feature feature : featureArray) {
            n |= feature.mask();
        }
        return this._with(n);
    }

    public JSON without(Feature ... featureArray) {
        int n = this._features;
        for (Feature feature : featureArray) {
            n &= ~feature.mask();
        }
        return this._with(n);
    }

    protected final JSON _with(int n) {
        if (this._features == n) {
            return this;
        }
        JSONReader jSONReader = this._reader.withCacheCheck(n);
        JSONWriter jSONWriter = this._writer.withCacheCheck(n);
        return this._with(n, this._jsonFactory, this._treeCodec, jSONReader, jSONWriter, this._prettyPrinter);
    }

    @Deprecated
    public JSON with(JsonFactory jsonFactory) {
        return this._with(this._features, jsonFactory, this._treeCodec, this._reader, this._writer, this._prettyPrinter);
    }

    @Deprecated
    public JSON with(TreeCodec treeCodec) {
        if (treeCodec == this._treeCodec) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, treeCodec, this._reader, this._writer, this._prettyPrinter);
    }

    @Deprecated
    public JSON with(JSONReader jSONReader) {
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    @Deprecated
    public JSON with(JSONWriter jSONWriter) {
        if (jSONWriter == this._writer) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, this._reader, jSONWriter, this._prettyPrinter);
    }

    public JSON with(MapBuilder mapBuilder) {
        JSONReader jSONReader = this._reader.with(mapBuilder);
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    public JSON with(CollectionBuilder collectionBuilder) {
        JSONReader jSONReader = this._reader.with(collectionBuilder);
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    @Deprecated
    public JSON with(ReaderWriterProvider readerWriterProvider) {
        ValueReaderLocator valueReaderLocator = this._valueReaderLocator.with(readerWriterProvider);
        ValueWriterLocator valueWriterLocator = this._valueWriterLocator.with(readerWriterProvider);
        if (valueReaderLocator == this._valueReaderLocator && valueWriterLocator == this._valueWriterLocator) {
            return this;
        }
        return new JSON(this, valueReaderLocator, valueWriterLocator);
    }

    protected JSON _with(int n, JsonFactory jsonFactory, TreeCodec treeCodec, JSONReader jSONReader, JSONWriter jSONWriter, PrettyPrinter prettyPrinter) {
        return new JSON(this, n, jsonFactory, treeCodec, jSONReader, jSONWriter, prettyPrinter);
    }

    public TreeCodec getTreeCodec() {
        return this._treeCodec;
    }

    public JsonFactory getStreamingFactory() {
        return this._jsonFactory;
    }

    public final boolean isEnabled(Feature feature) {
        return (feature.mask() & this._features) != 0;
    }

    public JsonParser createParser(Object object) throws IOException, JSONObjectException {
        return this._parser(object);
    }

    public String asString(Object object) throws IOException, JSONObjectException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        try {
            this._writeAndClose(object, this._jsonFactory.createGenerator(segmentedStringWriter));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JSONObjectException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] asBytes(Object object) throws IOException, JSONObjectException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        try {
            this._writeAndClose(object, this._jsonFactory.createGenerator(byteArrayBuilder, JsonEncoding.UTF8));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JSONObjectException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public void write(Object object, JsonGenerator jsonGenerator) throws IOException, JSONObjectException {
        this._writerForOperation(jsonGenerator).writeValue(object);
        if (Feature.FLUSH_AFTER_WRITE_VALUE.isEnabled(this._features)) {
            jsonGenerator.flush();
        }
    }

    public void write(Object object, OutputStream outputStream) throws IOException, JSONObjectException {
        this._writeAndClose(object, this._jsonFactory.createGenerator(outputStream));
    }

    public void write(Object object, Writer writer) throws IOException, JSONObjectException {
        this._writeAndClose(object, this._jsonFactory.createGenerator(writer));
    }

    public void write(Object object, File file) throws IOException, JSONObjectException {
        this._writeAndClose(object, this._jsonFactory.createGenerator(file, JsonEncoding.UTF8));
    }

    public JSONComposer<OutputStream> composeUsing(JsonGenerator jsonGenerator) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, jsonGenerator, false);
    }

    public JSONComposer<OutputStream> composeTo(OutputStream outputStream) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, this._config(this._jsonFactory.createGenerator(outputStream)), true);
    }

    public JSONComposer<OutputStream> composeTo(Writer writer) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, this._config(this._jsonFactory.createGenerator(writer)), true);
    }

    public JSONComposer<OutputStream> composeTo(File file) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, this._config(this._jsonFactory.createGenerator(file, JsonEncoding.UTF8)), true);
    }

    public JSONComposer<String> composeString() throws IOException, JSONObjectException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        JsonGenerator jsonGenerator = this._config(this._jsonFactory.createGenerator(segmentedStringWriter).setCodec(this.asCodec()));
        return JSONComposer.stringComposer(this._features, jsonGenerator, segmentedStringWriter);
    }

    public JSONComposer<byte[]> composeBytes() throws IOException, JSONObjectException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        JsonGenerator jsonGenerator = this._config(this._jsonFactory.createGenerator(byteArrayBuilder).setCodec(this.asCodec()));
        return JSONComposer.bytesComposer(this._features, jsonGenerator, byteArrayBuilder);
    }

    public CollectionComposer<?, List<Object>> composeList() {
        ArrayList arrayList = new ArrayList();
        return this.composeCollection(arrayList);
    }

    public <C extends Collection<Object>> CollectionComposer<?, C> composeCollection(C c) {
        return new CollectionComposer(c);
    }

    public MapComposer<?> composeMap() {
        return this.composeMap(new LinkedHashMap<String, Object>());
    }

    public MapComposer<?> composeMap(Map<String, Object> map) {
        return new MapComposer(map);
    }

    public List<Object> listFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            List<Object> list = this._readerForOperation(jsonParser).readList();
            jsonParser.clearCurrentToken();
            return list;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            List<Object> list = this._readerForOperation(jsonParser).readList();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return list;
        }
        catch (Exception exception) {
            return (List)this._closeWithError(jsonParser, exception);
        }
    }

    public <T> List<T> listOfFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            List<T> list = this._readerForOperation(jsonParser).readListOf(clazz);
            jsonParser.clearCurrentToken();
            return list;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            List<T> list = this._readerForOperation(jsonParser).readListOf(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return list;
        }
        catch (Exception exception) {
            return (List)this._closeWithError(jsonParser, exception);
        }
    }

    public Object[] arrayFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object[] objectArray = this._readerForOperation(jsonParser).readArray();
            jsonParser.clearCurrentToken();
            return objectArray;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Object[] objectArray = this._readerForOperation(jsonParser).readArray();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return objectArray;
        }
        catch (Exception exception) {
            return (Object[])this._closeWithError(jsonParser, exception);
        }
    }

    public <T> T[] arrayOfFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            T[] TArray = this._readerForOperation(jsonParser).readArrayOf(clazz);
            jsonParser.clearCurrentToken();
            return TArray;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            T[] TArray = this._readerForOperation(jsonParser).readArrayOf(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return TArray;
        }
        catch (Exception exception) {
            return (Object[])this._closeWithError(jsonParser, exception);
        }
    }

    public Map<String, Object> mapFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Map<String, Object> map = this._readerForOperation(jsonParser).readMap();
            jsonParser.clearCurrentToken();
            return map;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Map<String, Object> map = this._readerForOperation(jsonParser).readMap();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return map;
        }
        catch (Exception exception) {
            return (Map)this._closeWithError(jsonParser, exception);
        }
    }

    public <T> Map<String, T> mapOfFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Map<String, T> map = this._readerForOperation(jsonParser).readMapOf(clazz);
            jsonParser.clearCurrentToken();
            return map;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Map<String, T> map = this._readerForOperation(jsonParser).readMapOf(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return map;
        }
        catch (Exception exception) {
            return (Map)this._closeWithError(jsonParser, exception);
        }
    }

    public <T> T beanFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            T t = this._readerForOperation(jsonParser).readBean(clazz);
            jsonParser.clearCurrentToken();
            return t;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            T t = this._readerForOperation(jsonParser).readBean(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return t;
        }
        catch (Exception exception) {
            return this._closeWithError(jsonParser, exception);
        }
    }

    public Object anyFrom(Object object) throws IOException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object object2 = this._readerForOperation(jsonParser).readValue();
            jsonParser.clearCurrentToken();
            return object2;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Object object3 = this._readerForOperation(jsonParser).readValue();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return object3;
        }
        catch (Exception exception) {
            this._closeWithError(jsonParser, exception);
            return null;
        }
    }

    public <T extends TreeNode> T treeFrom(Object object) throws IOException, JSONObjectException {
        if (this._treeCodec == null) {
            this._noTreeCodec("read `TreeNode`");
        }
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object t = this._treeCodec.readTree(jsonParser);
            jsonParser.clearCurrentToken();
            return t;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Object t = this._treeCodec.readTree(jsonParser);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close(jsonParser2);
            return t;
        }
        catch (Exception exception) {
            this._closeWithError(jsonParser, exception);
            return null;
        }
    }

    public <T> ValueIterator<T> beanSequenceFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        boolean bl = !(object instanceof JsonParser);
        JsonParser jsonParser = bl ? this._parser(object) : (JsonParser)object;
        jsonParser = this._initForReading(this._config(jsonParser));
        JSONReader jSONReader = this._readerForOperation(jsonParser);
        return new ValueIterator(1, clazz, jsonParser, jSONReader, this._treeCodec, bl);
    }

    public ValueIterator<Object> anySequenceFrom(Object object) throws IOException, JSONObjectException {
        boolean bl = !(object instanceof JsonParser);
        JsonParser jsonParser = bl ? this._parser(object) : (JsonParser)object;
        jsonParser = this._initForReading(this._config(jsonParser));
        JSONReader jSONReader = this._readerForOperation(jsonParser);
        return new ValueIterator<Object>(2, Object.class, jsonParser, jSONReader, this._treeCodec, bl);
    }

    public <T extends TreeNode> ValueIterator<T> treeSequenceFrom(Object object) throws IOException, JSONObjectException {
        if (this._treeCodec == null) {
            this._noTreeCodec("read `TreeNode` sequence");
        }
        boolean bl = !(object instanceof JsonParser);
        JsonParser jsonParser = bl ? this._parser(object) : (JsonParser)object;
        jsonParser = this._initForReading(this._config(jsonParser));
        JSONReader jSONReader = this._readerForOperation(jsonParser);
        return new ValueIterator(3, TreeNode.class, jsonParser, jSONReader, this._treeCodec, bl);
    }

    public <T extends TreeNode> T createArrayNode() {
        if (this._treeCodec == null) {
            this._noTreeCodec("create Array node");
        }
        return (T)this._treeCodec.createArrayNode();
    }

    public <T extends TreeNode> T createObjectNode() {
        if (this._treeCodec == null) {
            this._noTreeCodec("create Object node");
        }
        return (T)this._treeCodec.createObjectNode();
    }

    protected final void _writeAndClose(Object object, JsonGenerator jsonGenerator) throws IOException {
        try (JsonGenerator jsonGenerator2 = jsonGenerator;){
            this._config(jsonGenerator2);
            this._writerForOperation(jsonGenerator2).writeValue(object);
        }
    }

    protected JSONWriter _writerForOperation(JsonGenerator jsonGenerator) {
        return this._writer.perOperationInstance(this._features, this._valueWriterLocator, this._treeCodec, jsonGenerator);
    }

    protected JSONReader _readerForOperation(JsonParser jsonParser) {
        return this._reader.perOperationInstance(this._features, this._valueReaderLocator, this._treeCodec, jsonParser);
    }

    protected JsonParser _parser(Object object) throws IOException, JSONObjectException {
        JsonFactory jsonFactory = this._jsonFactory;
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            return jsonFactory.createParser((String)object);
        }
        if (clazz == byte[].class) {
            return jsonFactory.createParser((byte[])object);
        }
        if (object instanceof InputStream) {
            return jsonFactory.createParser((InputStream)object);
        }
        if (object instanceof Reader) {
            return jsonFactory.createParser((Reader)object);
        }
        if (object instanceof URL) {
            return jsonFactory.createParser((URL)object);
        }
        if (clazz == char[].class) {
            return jsonFactory.createParser(new CharArrayReader((char[])object));
        }
        if (object instanceof File) {
            return jsonFactory.createParser((File)object);
        }
        if (object instanceof CharSequence) {
            return jsonFactory.createParser(((CharSequence)object).toString());
        }
        throw new JSONObjectException("Can not use Source of type `" + object.getClass().getName() + "` as input (use an `InputStream`, `Reader`, `String`/`CharSequence`, `byte[]`, `char[]`, `File` or `URL`");
    }

    protected JsonParser _initForReading(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JSONObjectException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonParser;
    }

    protected JsonGenerator _config(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter = this._prettyPrinter;
        if (prettyPrinter != null) {
            if (prettyPrinter instanceof Instantiatable) {
                prettyPrinter = (PrettyPrinter)((Instantiatable)((Object)prettyPrinter)).createInstance();
            }
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        } else if (this.isEnabled(Feature.PRETTY_PRINT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        return jsonGenerator;
    }

    protected JsonParser _config(JsonParser jsonParser) {
        return jsonParser;
    }

    protected <T> T _closeWithError(Closeable closeable, Exception exception) throws IOException {
        this._close(closeable);
        return this._throw(exception);
    }

    protected void _close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected <T> T _throw(Exception exception) throws IOException {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new IOException(exception);
    }

    protected void _noTreeCodec(String string) {
        throw new IllegalStateException("JSON instance does not have configured `TreeCodec` to " + string);
    }

    private static class ExtContextImpl
    extends ExtensionContext {
        final Builder _builder;
        ReaderWriterProvider _rwProvider;
        ReaderWriterModifier _rwModifier;

        ExtContextImpl(Builder builder) {
            this._builder = builder;
        }

        @Override
        public boolean isEnabled(Feature feature) {
            return this._builder.isEnabled(feature);
        }

        @Override
        public ExtensionContext setTreeCodec(TreeCodec treeCodec) {
            this._builder.treeCodec(treeCodec);
            return this;
        }

        @Override
        public TreeCodec treeCodec() {
            return this._builder.treeCodec();
        }

        @Override
        public ExtensionContext insertProvider(ReaderWriterProvider readerWriterProvider) {
            this._rwProvider = ReaderWriterProvider.Pair.of(readerWriterProvider, this._rwProvider);
            return this;
        }

        @Override
        public ExtensionContext appendProvider(ReaderWriterProvider readerWriterProvider) {
            this._rwProvider = ReaderWriterProvider.Pair.of(this._rwProvider, readerWriterProvider);
            return this;
        }

        @Override
        public ExtensionContext insertModifier(ReaderWriterModifier readerWriterModifier) {
            this._rwModifier = ReaderWriterModifier.Pair.of(readerWriterModifier, this._rwModifier);
            return this;
        }

        @Override
        public ExtensionContext appendModifier(ReaderWriterModifier readerWriterModifier) {
            this._rwModifier = ReaderWriterModifier.Pair.of(this._rwModifier, readerWriterModifier);
            return this;
        }
    }

    public static class Builder {
        protected int _features = DEFAULT_FEATURES;
        protected PrettyPrinter _prettyPrinter;
        protected final JsonFactory _streamFactory;
        protected TreeCodec _treeCodec;
        protected JSONReader _reader;
        protected JSONWriter _writer;
        protected MapBuilder _mapBuilder;
        protected CollectionBuilder _collectionBuilder;
        protected ExtContextImpl _extContext;

        public Builder(JsonFactory jsonFactory) {
            this._streamFactory = jsonFactory;
        }

        public JSON build() {
            return new JSON(this);
        }

        public Builder register(JacksonJrExtension jacksonJrExtension) {
            if (this._extContext == null) {
                this._extContext = new ExtContextImpl(this);
            }
            jacksonJrExtension.register(this._extContext);
            return this;
        }

        public Builder set(Feature feature, boolean bl) {
            this._features = bl ? (this._features |= feature.mask()) : (this._features &= ~feature.mask());
            return this;
        }

        public Builder enable(Feature ... featureArray) {
            for (Feature feature : featureArray) {
                this._features |= feature.mask();
            }
            return this;
        }

        public Builder disable(Feature ... featureArray) {
            for (Feature feature : featureArray) {
                this._features &= ~feature.mask();
            }
            return this;
        }

        public Builder prettyPrinter(PrettyPrinter prettyPrinter) {
            this._prettyPrinter = prettyPrinter;
            return this;
        }

        @Deprecated
        public Builder treeCodec(TreeCodec treeCodec) {
            this._treeCodec = treeCodec;
            return this;
        }

        public Builder jsonReader(JSONReader jSONReader) {
            if (this._collectionBuilder != null) {
                jSONReader = jSONReader.with(this._collectionBuilder);
            }
            if (this._mapBuilder != null) {
                jSONReader = jSONReader.with(this._mapBuilder);
            }
            this._reader = jSONReader;
            return this;
        }

        public Builder jsonWriter(JSONWriter jSONWriter) {
            this._writer = jSONWriter;
            return this;
        }

        public Builder collectionBuilder(CollectionBuilder collectionBuilder) {
            this._collectionBuilder = collectionBuilder;
            if (this._reader != null) {
                this._reader = this._reader.with(collectionBuilder);
            }
            return this;
        }

        public Builder mapBuilder(MapBuilder mapBuilder) {
            this._mapBuilder = mapBuilder;
            if (this._reader != null) {
                this._reader = this._reader.with(mapBuilder);
            }
            return this;
        }

        public boolean isEnabled(Feature feature) {
            return feature.isEnabled(this._features);
        }

        public int featureMask() {
            return this._features;
        }

        public PrettyPrinter prettyPrinter() {
            return this._prettyPrinter;
        }

        public JsonFactory streamFactory() {
            return this._streamFactory;
        }

        public TreeCodec treeCodec() {
            return this._treeCodec;
        }

        public ReaderWriterModifier readerWriterModifier() {
            return this._extContext == null ? null : this._extContext._rwModifier;
        }

        public ReaderWriterProvider readerWriterProvider() {
            return this._extContext == null ? null : this._extContext._rwProvider;
        }

        public JSONReader jsonReader() {
            if (this._reader == null) {
                this._reader = new JSONReader(this.collectionBuilder(), this.mapBuilder());
            }
            return this._reader;
        }

        public JSONWriter jsonWriter() {
            if (this._writer == null) {
                this._writer = new JSONWriter();
            }
            return this._writer;
        }

        public MapBuilder mapBuilder() {
            if (this._mapBuilder == null) {
                this._mapBuilder = MapBuilder.defaultImpl();
            }
            return this._mapBuilder;
        }

        public CollectionBuilder collectionBuilder() {
            if (this._collectionBuilder == null) {
                this._collectionBuilder = CollectionBuilder.defaultImpl();
            }
            return this._collectionBuilder;
        }
    }

    public static enum Feature {
        USE_BIG_DECIMAL_FOR_FLOATS(false),
        READ_JSON_ARRAYS_AS_JAVA_ARRAYS(false),
        READ_ONLY(false),
        PRESERVE_FIELD_ORDERING(true),
        USE_DEFERRED_MAPS(true),
        FAIL_ON_DUPLICATE_MAP_KEYS(true),
        FAIL_ON_UNKNOWN_BEAN_PROPERTY(false),
        WRITE_NULL_PROPERTIES(false),
        WRITE_ENUMS_USING_INDEX(false),
        WRITE_DATES_AS_TIMESTAMP(false),
        PRETTY_PRINT_OUTPUT(false),
        FLUSH_AFTER_WRITE_VALUE(true),
        FAIL_ON_UNKNOWN_TYPE_WRITE(false),
        HANDLE_JAVA_BEANS(true, true),
        WRITE_READONLY_BEAN_PROPERTIES(true, true),
        FORCE_REFLECTION_ACCESS(true, true),
        USE_IS_GETTERS(true, true),
        USE_FIELD_MATCHING_GETTERS(false, true),
        USE_FIELDS(true, true),
        INCLUDE_STATIC_FIELDS(false, true),
        ACCEPT_CASE_INSENSITIVE_PROPERTIES(false, true),
        ACCEPT_CASE_INSENSITIVE_ENUMS(false, true);

        private final boolean _defaultState;
        private final boolean _affectsCaching;
        private final int _mask;

        private Feature(boolean bl) {
            this(bl, false);
        }

        private Feature(boolean bl, boolean bl2) {
            this._defaultState = bl;
            this._affectsCaching = bl2;
            this._mask = 1 << this.ordinal();
        }

        public static int defaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.mask();
            }
            return n;
        }

        public static int cacheBreakers() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.affectsCaching()) continue;
                n |= feature.mask();
            }
            return n;
        }

        public final boolean enabledByDefault() {
            return this._defaultState;
        }

        public final boolean affectsCaching() {
            return this._affectsCaching;
        }

        public final int mask() {
            return this._mask;
        }

        public final boolean isDisabled(int n) {
            return (n & this._mask) == 0;
        }

        public final boolean isEnabled(int n) {
            return (n & this._mask) != 0;
        }
    }
}

