/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ParseException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class BXCompiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BoxRuntime runtime = BoxRuntime.getInstance();
        try {
            String base = ".";
            String source = ".";
            String target = null;
            String mapping = "";
            Boolean stopOnError = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--mapping")) {
                    if (i + 1 >= args.length) {
                        throw new BoxRuntimeException("--mapping requires a name like [modules.myModule]");
                    }
                    mapping = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("--basePath")) {
                    if (i + 1 >= args.length) {
                        throw new BoxRuntimeException("--basePath requires a path");
                    }
                    base = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("--source")) {
                    if (i + 1 >= args.length) {
                        throw new BoxRuntimeException("--source requires a path");
                    }
                    source = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("--target")) {
                    if (i + 1 >= args.length) {
                        throw new BoxRuntimeException("--target requires a path");
                    }
                    target = args[i + 1];
                }
                if (!args[i].equalsIgnoreCase("--stopOnError")) continue;
                stopOnError = i + 1 >= args.length || args[i + 1].startsWith("--") ? Boolean.valueOf(true) : Boolean.valueOf(Boolean.parseBoolean(args[i + 1]));
            }
            mapping = mapping.replace("/", ".").replace("\\", ".");
            while (mapping.contains("..")) {
                mapping = mapping.replace("..", ".");
            }
            if (mapping.startsWith(".")) {
                mapping = mapping.substring(1);
            }
            if (mapping.endsWith(".")) {
                mapping = mapping.substring(0, mapping.length() - 1);
            }
            String finalMapping = mapping;
            Path basePath = Paths.get(base, new String[0]).normalize();
            if (!basePath.isAbsolute()) {
                basePath = Paths.get("", new String[0]).resolve(basePath).normalize().toAbsolutePath().normalize();
            }
            Path finalBasePath = basePath;
            Path sourcePath = Paths.get(source, new String[0]).normalize();
            if (!sourcePath.isAbsolute()) {
                sourcePath = Paths.get("", new String[0]).resolve(sourcePath).normalize().toAbsolutePath().normalize();
            }
            if (!sourcePath.toFile().exists()) {
                System.out.println("Source Path does not exist: " + sourcePath.toString());
                System.exit(1);
            }
            if (!sourcePath.startsWith(basePath)) {
                throw new BoxRuntimeException("Source path must be equal to or a subdirectory of the base path");
            }
            if (target == null) {
                throw new BoxRuntimeException("--target is required ");
            }
            Path targetPath = Paths.get(target, new String[0]).normalize();
            if (!targetPath.isAbsolute()) {
                targetPath = Paths.get("", new String[0]).resolve(targetPath).normalize().toAbsolutePath().normalize();
            }
            if (sourcePath.toFile().isDirectory()) {
                System.out.println("Transpiling all .cfm files in " + sourcePath.toString() + " to " + targetPath.toString());
                Path finalTargetPath = targetPath;
                try {
                    Path finalSourcePath = sourcePath;
                    boolean finalStopOnError = stopOnError;
                    ((Stream)Files.walk(finalSourcePath, new FileVisitOption[0]).parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        String sourceExtension = path.getFileName().toString().substring(path.getFileName().toString().lastIndexOf(".") + 1);
                        if (sourceExtension.equals("cfm") || sourceExtension.equals("cfc") || sourceExtension.equals("cfs")) {
                            String targetExtension = sourceExtension;
                            Path resolvedTargetPath = finalTargetPath.resolve(finalSourcePath.relativize((Path)path).toString().substring(0, finalSourcePath.relativize((Path)path).toString().length() - 3) + targetExtension);
                            BXCompiler.compileFile(path, resolvedTargetPath, finalStopOnError, runtime, finalBasePath, finalMapping);
                        }
                    });
                }
                catch (IOException e) {
                    throw new BoxRuntimeException("Error walking source path", e);
                }
            } else {
                String sourceExtension;
                String targetExtension = sourceExtension = sourcePath.getFileName().toString().substring(sourcePath.getFileName().toString().lastIndexOf(".") + 1);
                String trgName = targetPath.getFileName().toString();
                if (targetPath.toFile().isDirectory() && !trgName.endsWith(".bx") && !trgName.endsWith(".bxs") && !trgName.endsWith(".bxm")) {
                    targetPath = targetPath.resolve(sourcePath.getFileName().toString().replace(sourceExtension, targetExtension));
                } else if (!trgName.endsWith(targetExtension)) {
                    targetPath = targetPath.resolveSibling(trgName + "." + targetExtension);
                }
                BXCompiler.compileFile(sourcePath, targetPath, stopOnError, runtime, finalBasePath, finalMapping);
            }
            System.exit(0);
        }
        finally {
            runtime.shutdown();
        }
    }

    public static void compileFile(Path sourcePath, Path targetPath, Boolean stopOnError, BoxRuntime runtime, Path basePath, String mapping) {
        try {
            Path directoryPath = targetPath.getParent();
            if (directoryPath != null && !Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException directoryPath) {
            // empty catch block
        }
        System.out.println("Writing " + targetPath.toString());
        List<byte[]> bytesList = null;
        try {
            Path relativePath = basePath.relativize(sourcePath);
            bytesList = JavaBoxpiler.getInstance().compileTemplateBytes(ResolvedFilePath.of(mapping, basePath.toString(), relativePath.toString(), sourcePath));
        }
        catch (ParseException e) {
            if (stopOnError.booleanValue()) {
                throw e;
            }
            System.err.println("Error compiling " + sourcePath.toString() + ": " + e.getMessage());
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(ByteBuffer.allocate(4).putInt(-889275714).array());
            for (byte[] bytes : bytesList) {
                baos.write(ByteBuffer.allocate(4).putInt(bytes.length).array());
                baos.write(bytes);
            }
            Files.write(targetPath, baos.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to target file", e);
        }
    }
}

