/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.compiler.DiskClassUtil;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.SourceMap;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyDefinition;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.runnables.IProxyRunnable;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ParseException;
import ortus.boxlang.runtime.util.FRTransService;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public abstract class Boxpiler
implements IBoxpiler {
    protected static final Logger logger = LoggerFactory.getLogger(JavaBoxpiler.class);
    protected Map<String, Map<String, ClassInfo>> classPools = new ConcurrentHashMap<String, Map<String, ClassInfo>>();
    protected FRTransService frTransService = FRTransService.getInstance(true);
    protected DiskClassUtil diskClassUtil;
    protected Path classGenerationDirectory;

    public Boxpiler() {
        this.classGenerationDirectory = Paths.get(BoxRuntime.getInstance().getConfiguration().classGenerationDirectory, new String[0]);
        this.diskClassUtil = new DiskClassUtil(this.classGenerationDirectory);
        this.classGenerationDirectory.toFile().mkdirs();
        if (BoxRuntime.getInstance().inDebugMode().booleanValue() && Files.exists(this.classGenerationDirectory, new LinkOption[0])) {
            try {
                logger.debug("Running in debugmode, first startup cleaning out class generation directory: " + String.valueOf(this.classGenerationDirectory));
                FileUtils.cleanDirectory(this.classGenerationDirectory.toFile());
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error cleaning out class generation directory on first run", e);
            }
        }
    }

    @Override
    public Map<String, ClassInfo> getClassPool(String classPoolName) {
        return this.classPools.computeIfAbsent(classPoolName, k -> new ConcurrentHashMap());
    }

    public Map<String, Map<String, ClassInfo>> getClassPools() {
        return this.classPools;
    }

    @Override
    public void clearPagePool() {
        this.getClassPools().forEach((k, v) -> v.clear());
    }

    @Override
    public ParsingResult parse(String source, BoxSourceType type, Boolean classOrInterface) {
        DynamicObject trans = this.frTransService.startTransaction("BL Source Parse", type.name());
        Parser parser = new Parser();
        try {
            ParsingResult parsingResult = parser.parse(source, type, classOrInterface);
            return parsingResult;
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Error compiling source", e);
        }
        finally {
            this.frTransService.endTransaction(trans);
        }
    }

    @Override
    public ParsingResult parseOrFail(File file) {
        return this.validateParse(this.parse(file), file.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsingResult parse(File file) {
        DynamicObject trans = this.frTransService.startTransaction("BL File Parse", file.toString());
        Parser parser = new Parser();
        try {
            ParsingResult parsingResult = parser.parse(file);
            return parsingResult;
        }
        finally {
            this.frTransService.endTransaction(trans);
        }
    }

    @Override
    public ParsingResult parseOrFail(String source, BoxSourceType type, Boolean classOrInterface) {
        return this.validateParse(this.parse(source, type, classOrInterface), "ad-hoc source");
    }

    @Override
    public ParsingResult validateParse(ParsingResult result, String source) {
        if (!result.isCorrect()) {
            throw new ParseException(result.getIssues(), source);
        }
        return result;
    }

    @Override
    public Class<IBoxRunnable> compileStatement(String source, BoxSourceType type) {
        ClassInfo classInfo = ClassInfo.forStatement(source, type, this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        classInfo = classPool.get(classInfo.fqn().toString());
        return classInfo.getDiskClass();
    }

    @Override
    public Class<IBoxRunnable> compileScript(String source, BoxSourceType type) {
        ClassInfo classInfo = ClassInfo.forScript(source, type, this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        classInfo = classPool.get(classInfo.fqn().toString());
        return classInfo.getDiskClass();
    }

    @Override
    public Class<IBoxRunnable> compileTemplate(ResolvedFilePath resolvedFilePath) {
        ClassInfo classInfo = ClassInfo.forTemplate(resolvedFilePath, Parser.detectFile(resolvedFilePath.absolutePath().toFile()), this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        if (classPool.get(classInfo.fqn().toString()).lastModified() < classInfo.lastModified()) {
            try {
                classPool.get(classInfo.fqn().toString()).getClassLoader().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            classPool.put(classInfo.fqn().toString(), classInfo);
            this.compileClassInfo(classInfo.classPoolName(), classInfo.fqn().toString());
        } else {
            classInfo = classPool.get(classInfo.fqn().toString());
        }
        return classInfo.getDiskClass();
    }

    @Override
    public Class<IBoxRunnable> compileClass(String source, BoxSourceType type) {
        ClassInfo classInfo = ClassInfo.forClass(source, type, (IBoxpiler)this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        classInfo = classPool.get(classInfo.fqn().toString());
        return classInfo.getDiskClass();
    }

    @Override
    public Class<IBoxRunnable> compileClass(ResolvedFilePath resolvedFilePath) {
        ClassInfo classInfo = ClassInfo.forClass(resolvedFilePath, Parser.detectFile(resolvedFilePath.absolutePath().toFile()), (IBoxpiler)this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        if (classPool.get(classInfo.fqn().toString()).lastModified() < classInfo.lastModified()) {
            try {
                classPool.get(classInfo.fqn().toString()).getClassLoader().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            classPool.put(classInfo.fqn().toString(), classInfo);
            this.compileClassInfo(classInfo.classPoolName(), classInfo.fqn().toString());
        } else {
            classInfo = classPool.get(classInfo.fqn().toString());
        }
        return classInfo.getDiskClass();
    }

    @Override
    public Class<IProxyRunnable> compileInterfaceProxy(IBoxContext context, InterfaceProxyDefinition definition) {
        ClassInfo classInfo = ClassInfo.forInterfaceProxy(definition.name(), definition, this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        classInfo = classPool.get(classInfo.fqn().toString());
        return classInfo.getDiskClassProxy();
    }

    @Override
    public SourceMap getSourceMapFromFQN(String FQN2) {
        String classPoolName = null;
        for (Map.Entry<String, Map<String, ClassInfo>> entry : this.classPools.entrySet()) {
            if (!entry.getValue().containsKey(FQN2)) continue;
            classPoolName = entry.getKey();
            break;
        }
        if (classPoolName == null) {
            return null;
        }
        return this.diskClassUtil.readLineNumbers(classPoolName, IBoxpiler.getBaseFQN(FQN2));
    }
}

