/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class CFTranspiler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BoxRuntime runtime = BoxRuntime.getInstance();
        try {
            String source = ".";
            String target = null;
            Boolean stopOnError = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--source")) {
                    if (i + 1 >= args.length) {
                        throw new BoxRuntimeException("--source requires a path");
                    }
                    source = args[i + 1];
                }
                if (args[i].equalsIgnoreCase("--target")) {
                    if (i + 1 >= args.length) {
                        throw new BoxRuntimeException("--target requires a path");
                    }
                    target = args[i + 1];
                }
                if (!args[i].equalsIgnoreCase("--stopOnError")) continue;
                stopOnError = i + 1 >= args.length || args[i + 1].startsWith("--") ? Boolean.valueOf(true) : Boolean.valueOf(Boolean.parseBoolean(args[i + 1]));
            }
            Path sourcePath = Paths.get(source, new String[0]).normalize();
            if (!sourcePath.isAbsolute()) {
                sourcePath = Paths.get("", new String[0]).resolve(sourcePath).normalize().toAbsolutePath().normalize();
            }
            if (!sourcePath.toFile().exists()) {
                System.out.println("Source Path does not exist: " + sourcePath.toString());
                System.exit(1);
            }
            if (target == null) {
                throw new BoxRuntimeException("--target is required ");
            }
            Path targetPath = Paths.get(target, new String[0]).normalize();
            if (!targetPath.isAbsolute()) {
                targetPath = Paths.get("", new String[0]).resolve(targetPath).normalize().toAbsolutePath().normalize();
            }
            if (sourcePath.toFile().isDirectory()) {
                System.out.println("Transpiling all .cfm/.cfc/.cfs files in " + sourcePath.toString() + " to " + targetPath.toString());
                Path finalTargetPath = targetPath;
                try {
                    Path finalSourcePath = sourcePath;
                    boolean finalStopOnError = stopOnError;
                    ((Stream)Files.walk(finalSourcePath, new FileVisitOption[0]).parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        String sourceExtension = path.getFileName().toString().substring(path.getFileName().toString().lastIndexOf(".") + 1);
                        if (sourceExtension.equals("cfm") || sourceExtension.equals("cfc") || sourceExtension.equals("cfs")) {
                            String targetExtension = CFTranspiler.mapExtension(sourceExtension);
                            Path resolvedTargetPath = finalTargetPath.resolve(finalSourcePath.relativize((Path)path).toString().substring(0, finalSourcePath.relativize((Path)path).toString().length() - 3) + targetExtension);
                            CFTranspiler.transpileFile(path, resolvedTargetPath, finalStopOnError);
                        }
                    });
                }
                catch (IOException e) {
                    throw new BoxRuntimeException("Error walking source path", e);
                }
            } else {
                String sourceExtension = sourcePath.getFileName().toString().substring(sourcePath.getFileName().toString().lastIndexOf(".") + 1);
                String targetExtension = CFTranspiler.mapExtension(sourceExtension);
                String trgName = targetPath.getFileName().toString();
                if (targetPath.toFile().isDirectory() && !trgName.endsWith(".bx") && !trgName.endsWith(".bxs") && !trgName.endsWith(".bxm")) {
                    targetPath = targetPath.resolve(sourcePath.getFileName().toString().replace(sourceExtension, targetExtension));
                } else if (!trgName.endsWith(targetExtension)) {
                    targetPath = targetPath.resolveSibling(trgName + "." + targetExtension);
                }
                CFTranspiler.transpileFile(sourcePath, targetPath, stopOnError);
            }
            System.exit(0);
        }
        finally {
            runtime.shutdown();
        }
    }

    private static void transpileFile(Path sourcePath, Path targetPath, Boolean stopOnError) {
        try {
            Path directoryPath = targetPath.getParent();
            if (directoryPath != null && !Files.exists(directoryPath, new LinkOption[0])) {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
        }
        catch (IOException directoryPath) {
            // empty catch block
        }
        System.out.println("Writing " + targetPath.toString());
        ParsingResult result = new Parser().parse(sourcePath.toFile());
        if (result.isCorrect()) {
            try {
                Files.write(targetPath, result.getRoot().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error writing transpiled file", e);
            }
        } else {
            System.out.println("Parsing failed for " + sourcePath.toString());
            result.getIssues().forEach(System.out::println);
            if (stopOnError.booleanValue()) {
                System.exit(1);
            }
        }
    }

    private static String mapExtension(String extension) {
        switch (extension) {
            case "cfm": {
                return "bxm";
            }
            case "cfc": {
                return "bx";
            }
            case "cfs": {
                return "bxs";
            }
        }
        throw new BoxRuntimeException("Unsupported extension: " + extension);
    }
}

