/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.net.URL;
import java.nio.file.Paths;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyDefinition;
import ortus.boxlang.runtime.loader.DiskClassLoader;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.runnables.IProxyRunnable;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.BoxFQN;
import ortus.boxlang.runtime.util.FQN;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public record ClassInfo(FQN fqn, BoxFQN boxFqn, String baseclass, String returnType, BoxSourceType sourceType, String source, Long lastModified, DiskClassLoader[] diskClassLoader, InterfaceProxyDefinition interfaceProxyDefinition, IBoxpiler boxpiler, ResolvedFilePath resolvedFilePath) {
    @Override
    public int hashCode() {
        return this.fqn().toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ClassInfo) {
            return this.fqn().toString().equals(((ClassInfo)obj).fqn().toString());
        }
        return false;
    }

    public static ClassInfo forScript(String source, BoxSourceType sourceType, IBoxpiler boxpiler) {
        return new ClassInfo(FQN.of("boxgenerated.scripts", "Script_" + IBoxpiler.MD5(sourceType.toString() + source)), BoxFQN.of(""), "BoxScript", "Object", sourceType, source, 0L, new DiskClassLoader[1], null, boxpiler, null);
    }

    public static ClassInfo forStatement(String source, BoxSourceType sourceType, IBoxpiler boxpiler) {
        return new ClassInfo(FQN.of("boxgenerated.scripts", "Statement_" + IBoxpiler.MD5(sourceType.toString() + source)), BoxFQN.of(""), "BoxScript", "Object", sourceType, source, 0L, new DiskClassLoader[1], null, boxpiler, null);
    }

    public static ClassInfo forTemplate(ResolvedFilePath resolvedFilePath, BoxSourceType sourceType, IBoxpiler boxpiler) {
        return new ClassInfo(resolvedFilePath.getFQN("boxgenerated.templates"), resolvedFilePath.getBoxFQN("boxgenerated.templates"), "BoxTemplate", "void", sourceType, null, Math.min(resolvedFilePath.absolutePath().toFile().lastModified(), System.currentTimeMillis()), new DiskClassLoader[1], null, boxpiler, resolvedFilePath);
    }

    public static ClassInfo forClass(ResolvedFilePath resolvedFilePath, BoxSourceType sourceType, IBoxpiler boxpiler) {
        return new ClassInfo(resolvedFilePath.getFQN("boxgenerated.boxclass"), resolvedFilePath.getBoxFQN(), null, null, sourceType, null, Math.min(resolvedFilePath.absolutePath().toFile().lastModified(), System.currentTimeMillis()), new DiskClassLoader[1], null, boxpiler, resolvedFilePath);
    }

    public static ClassInfo forClass(String source, BoxSourceType sourceType, IBoxpiler boxpiler) {
        return new ClassInfo(FQN.of("boxgenerated.boxclass", "Class_" + IBoxpiler.MD5(source)), BoxFQN.of(""), null, null, sourceType, source, 0L, new DiskClassLoader[1], null, boxpiler, null);
    }

    public static ClassInfo forInterfaceProxy(String name, InterfaceProxyDefinition interfaceProxyDefinition, IBoxpiler boxpiler) {
        return new ClassInfo(FQN.of("boxgenerated.dynamicProxy", "InterfaceProxy_" + name), BoxFQN.of(""), null, null, null, null, 0L, new DiskClassLoader[1], interfaceProxyDefinition, boxpiler, null);
    }

    @Override
    public String toString() {
        if (this.resolvedFilePath != null) {
            return "Class Info-- sourcePath: [" + this.resolvedFilePath.absolutePath().toString() + "], fqn: [" + this.fqn().toString() + "]";
        }
        if (this.sourceType != null) {
            return "Class Info-- type: [" + String.valueOf((Object)this.sourceType) + "], fqn: [" + this.fqn().toString() + "]";
        }
        if (this.interfaceProxyDefinition != null) {
            return "Class Info-- interface proxy: [" + this.interfaceProxyDefinition.interfaces().toString() + "],  fqn: [" + this.fqn().toString() + "]";
        }
        return "Class Info-- fqn: [" + this.fqn().toString() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskClassLoader getClassLoader() {
        if (this.diskClassLoader[0] != null) {
            return this.diskClassLoader[0];
        }
        ClassInfo classInfo = this;
        synchronized (classInfo) {
            if (this.diskClassLoader[0] != null) {
                return this.diskClassLoader[0];
            }
            this.diskClassLoader[0] = new DiskClassLoader(new URL[0], this.boxpiler().getClass().getClassLoader(), Paths.get(BoxRuntime.getInstance().getConfiguration().classGenerationDirectory, new String[0]), this.boxpiler(), this.classPoolName());
            return this.diskClassLoader[0];
        }
    }

    public Class<IBoxRunnable> getDiskClass() {
        try {
            return this.getClassLoader().loadClass(this.fqn().toString());
        }
        catch (ClassNotFoundException e) {
            throw new BoxRuntimeException("Error compiling source " + this.fqn().toString(), e);
        }
    }

    public Class<IProxyRunnable> getDiskClassProxy() {
        try {
            return this.getClassLoader().loadClass(this.fqn().toString());
        }
        catch (ClassNotFoundException e) {
            throw new BoxRuntimeException("Error compiling source " + this.fqn().toString(), e);
        }
    }

    public String packageName() {
        return this.fqn().getPackageString();
    }

    public String className() {
        return this.fqn().getClassName();
    }

    public Boolean isClass() {
        return this.packageName().toString().startsWith("boxgenerated.boxclass");
    }

    public String classPoolName() {
        if (this.resolvedFilePath() != null) {
            if (this.resolvedFilePath().mappingPath() != null) {
                return this.resolvedFilePath().mappingPath().toString();
            }
            return "__empty_mapping__";
        }
        return "__ad_hoc_source__";
    }
}

