/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import ortus.boxlang.compiler.SourceMap;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.JSONUtil;

public class DiskClassUtil {
    private Path diskStore;

    public DiskClassUtil(Path diskStore) {
        this.diskStore = diskStore;
    }

    public boolean hasLineNumbers(String classPoolName, String name) {
        return this.generateDiskpath(classPoolName, name, "json").toFile().exists();
    }

    private Path generateDiskpath(String classPoolName, String name, String extension) {
        return Paths.get(this.diskStore.toString(), classPoolName.replaceAll("[^a-zA-Z0-9]", "_"), name.replace(".", File.separator) + "." + extension);
    }

    public void writeLineNumbers(String classPoolName, String fqn, String lineNumberJSON) {
        if (lineNumberJSON == null) {
            return;
        }
        this.writeBytes(classPoolName, fqn, "json", lineNumberJSON.getBytes());
    }

    public SourceMap readLineNumbers(String classPoolName, String fqn) {
        if (!this.hasLineNumbers(classPoolName, fqn)) {
            return null;
        }
        Path diskPath = this.generateDiskpath(classPoolName, fqn, "json");
        try {
            String json = new String(Files.readAllBytes(diskPath));
            return JSONUtil.fromJSON(SourceMap.class, json);
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Unable to read line number JSON file from disk", e);
        }
    }

    public void writeJavaSource(String classPoolName, String fqn, String javaSource) {
        this.writeBytes(classPoolName, fqn, "java", javaSource.getBytes());
    }

    public void writeBytes(String classPoolName, String fqn, String extension, byte[] bytes) {
        Path diskPath = this.generateDiskpath(classPoolName, fqn, extension);
        diskPath.toFile().getParentFile().mkdirs();
        try {
            Files.write(diskPath, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Unable to write Java Sourece file to disk", e);
        }
    }

    public List<byte[]> readClassBytes(String classPoolName, String fqn) {
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        Path diskPath = this.generateDiskpath(classPoolName, fqn, "class");
        bytes.add(fqn.getBytes());
        try {
            bytes.add(Files.readAllBytes(diskPath));
            File directory = diskPath.getParent().toFile();
            String outerClassName = diskPath.getFileName().toString().replace(".class", "");
            File[] innerClassFiles = directory.listFiles(file -> file.getName().startsWith(outerClassName + "$") && file.getName().endsWith(".class"));
            if (innerClassFiles != null) {
                for (File innerClassFile : innerClassFiles) {
                    bytes.add(Files.readAllBytes(innerClassFile.toPath()));
                }
            }
        }
        catch (IOException e) {
            throw new BoxRuntimeException("Unable to read class file from disk", e);
        }
        return bytes;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isJavaBytecode(File sourceFile) {
        try (FileInputStream fis = new FileInputStream(sourceFile);){
            DataInputStream dis;
            block17: {
                block16: {
                    boolean bl;
                    dis = new DataInputStream(fis);
                    try {
                        if (dis.available() >= 4) break block16;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    dis.close();
                    return bl;
                }
                if (dis.readInt() != -889275714) break block17;
                boolean bl = true;
                dis.close();
                return bl;
            }
            boolean bl = false;
            dis.close();
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file", e);
        }
    }
}

