/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import ortus.boxlang.compiler.ast.visitor.FeatureAuditVisitor;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class FeatureAudit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BoxRuntime runtime = BoxRuntime.getInstance();
        FeatureAuditVisitor.setupRuntimeStubs();
        HashMap<String, List<FeatureAuditVisitor.FeatureUsed>> results = new HashMap<String, List<FeatureAuditVisitor.FeatureUsed>>();
        HashMap<String, List<FeatureAuditVisitor.AggregateFeatureUsed>> aggregateResults = new HashMap<String, List<FeatureAuditVisitor.AggregateFeatureUsed>>();
        StringBuffer reportText = new StringBuffer();
        HashMap<String, Integer> filesProcessed = new HashMap<String, Integer>();
        try {
            String source = ".";
            Boolean missing = false;
            Boolean aggregate = false;
            Boolean summary = false;
            Object reportFile = null;
            Boolean quiet = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("--source")) {
                    if (i + 1 >= args.length || args[i + 1].startsWith("--")) {
                        throw new BoxRuntimeException("--source requires a path");
                    }
                    source = args[++i];
                }
                if (args[i].equalsIgnoreCase("--missing")) {
                    missing = true;
                }
                if (args[i].equalsIgnoreCase("--aggregate")) {
                    if (i + 1 < args.length && args[i + 1].equalsIgnoreCase("summary")) {
                        summary = true;
                        ++i;
                    }
                    aggregate = true;
                }
                if (args[i].equalsIgnoreCase("--reportFile")) {
                    if (i + 1 >= args.length || args[i + 1].startsWith("--")) {
                        throw new BoxRuntimeException("--reportFile requires a path");
                    }
                    reportFile = args[++i];
                }
                if (!args[i].equalsIgnoreCase("--quiet")) continue;
                quiet = true;
            }
            Path sourcePath = Paths.get(source, new String[0]).normalize();
            Path reportPath = null;
            if (!sourcePath.isAbsolute()) {
                sourcePath = Paths.get("", new String[0]).resolve(sourcePath).normalize().toAbsolutePath().normalize();
            }
            if (!sourcePath.toFile().exists()) {
                System.out.println("Source Path does not exist: " + sourcePath.toString());
                System.exit(1);
            }
            if (reportFile != null) {
                if (!((String)reportFile).endsWith(".csv")) {
                    reportFile = (String)reportFile + ".csv";
                }
                if (!(reportPath = Paths.get((String)reportFile, new String[0]).normalize()).isAbsolute()) {
                    reportPath = Paths.get("", new String[0]).resolve(reportPath).normalize().toAbsolutePath().normalize();
                }
                if (!reportPath.getParent().toFile().exists()) {
                    try {
                        Files.createDirectories(reportPath.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (aggregate.booleanValue()) {
                reportText.append("File,").append(FeatureAuditVisitor.AggregateFeatureUsed.csvHeader()).append("\n");
            } else {
                reportText.append("File,").append(FeatureAuditVisitor.FeatureUsed.csvHeader()).append("\n");
            }
            Boolean finalMissing = missing;
            Boolean finalAggregate = aggregate;
            Boolean finalQuiet = quiet;
            Boolean finalSummary = summary;
            Path finalReportPath = reportPath;
            if (sourcePath.toFile().isDirectory()) {
                System.out.println("Scanning all files in " + sourcePath.toString());
                System.out.println();
                try {
                    Path finalSourcePath = sourcePath;
                    ((Stream)Files.walk(finalSourcePath, new FileVisitOption[0]).parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        String sourceExtension = path.getFileName().toString().substring(path.getFileName().toString().lastIndexOf(".") + 1);
                        if (FeatureAudit.extensionWeCareAbout(sourceExtension, filesProcessed)) {
                            FeatureAudit.scanFile(path, results, aggregateResults, finalMissing, finalAggregate, finalReportPath != null, reportText, finalQuiet != false || finalSummary != false);
                        }
                    });
                }
                catch (IOException e) {
                    throw new BoxRuntimeException("Error walking source path", e);
                }
            } else {
                String sourceExtension = sourcePath.getFileName().toString().substring(sourcePath.getFileName().toString().lastIndexOf(".") + 1);
                if (FeatureAudit.extensionWeCareAbout(sourceExtension, filesProcessed)) {
                    FeatureAudit.scanFile(sourcePath, results, aggregateResults, finalMissing, finalAggregate, finalReportPath != null, reportText, finalQuiet != false || finalSummary != false);
                }
            }
            if (summary.booleanValue()) {
                if (finalReportPath != null) {
                    reportText.setLength(0);
                    reportText.append("Name,Type,Module,Missing,Count\n");
                }
                System.out.println();
                System.out.println("*******************");
                System.out.println("*     Summary     *");
                System.out.println("*******************");
                System.out.println();
                System.out.println("Files processed: " + filesProcessed.values().stream().mapToInt(Integer::intValue).sum());
                filesProcessed.forEach((k, v) -> System.out.println("  * ." + k + ": " + v));
                System.out.println();
                System.out.println();
                HashMap summaryData = new HashMap();
                results.forEach((k, v) -> v.forEach(f -> {
                    String key = String.format("%s%s (%s) - %s", new Object[]{f.missing() ? "[MISSING] " : "", f.name(), f.type(), f.module()});
                    if (summaryData.containsKey(key)) {
                        summaryData.put(key, ((FeatureAuditVisitor.AggregateFeatureUsed)summaryData.get(key)).increment());
                    } else {
                        summaryData.put(key, new FeatureAuditVisitor.AggregateFeatureUsed(f.name(), f.type(), f.module(), f.missing(), 1));
                    }
                }));
                summaryData.values().stream().sorted().forEach(data -> {
                    if (!finalQuiet.booleanValue()) {
                        System.out.println(data.toString());
                    }
                    if (finalReportPath != null) {
                        reportText.append(data.name()).append(",").append((Object)data.type()).append(",").append(data.module()).append(",").append(data.missing()).append(",").append(data.count()).append("\n");
                    }
                });
                if (finalReportPath != null) {
                    try {
                        Files.write(finalReportPath, reportText.toString().getBytes(), new OpenOption[0]);
                        System.out.println();
                        System.out.println("Report written to " + finalReportPath.toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (finalReportPath != null) {
                try {
                    Files.write(finalReportPath, reportText.toString().getBytes(), new OpenOption[0]);
                    System.out.println();
                    System.out.println("Report written to " + finalReportPath.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            System.exit(0);
        }
        finally {
            runtime.shutdown();
        }
    }

    private static void scanFile(Path sourcePath, Map<String, List<FeatureAuditVisitor.FeatureUsed>> results, Map<String, List<FeatureAuditVisitor.AggregateFeatureUsed>> aggregateResults, Boolean missing, Boolean aggregate, boolean doReport, StringBuffer reportText, boolean quiet) {
        ParsingResult result;
        System.out.println("Processing: " + sourcePath.toString());
        try {
            result = new Parser().parse(sourcePath.toFile());
        }
        catch (Throwable e) {
            System.out.println("Parsing failed: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        if (result.isCorrect()) {
            FeatureAuditVisitor visitor = new FeatureAuditVisitor();
            result.getRoot().accept(visitor);
            if (missing.booleanValue()) {
                results.put(sourcePath.toString(), visitor.getFeaturesUsed().stream().filter(f -> f.missing()).toList());
                aggregateResults.put(sourcePath.toString(), visitor.getAggregateFeaturesUsed().stream().filter(f -> f.missing()).toList());
            } else {
                results.put(sourcePath.toString(), visitor.getFeaturesUsed());
                aggregateResults.put(sourcePath.toString(), visitor.getAggregateFeaturesUsed());
            }
            if (aggregate.booleanValue()) {
                if (aggregateResults.get(sourcePath.toString()).size() > 0) {
                    aggregateResults.get(sourcePath.toString()).forEach(data -> {
                        if (!quiet) {
                            System.out.println(data);
                        }
                        if (doReport) {
                            reportText.append(sourcePath.toString()).append(",").append(data.toCSV()).append("\n");
                        }
                    });
                }
            } else if (results.get(sourcePath.toString()).size() > 0) {
                results.get(sourcePath.toString()).forEach(data -> {
                    if (!quiet) {
                        System.out.println(data);
                    }
                    if (doReport) {
                        reportText.append(sourcePath.toString()).append(",").append(data.toCSV()).append("\n");
                    }
                });
            }
        } else {
            System.out.println("Parsing failed for " + sourcePath.toString());
            result.getIssues().forEach(System.out::println);
        }
    }

    private static boolean extensionWeCareAbout(String extension, Map<String, Integer> filesProcessed) {
        if ((extension = extension.toLowerCase()).equals("cfm") || extension.equals("cfc") || extension.equals("cfs") || extension.equals("cfml") || extension.equals("bxs") || extension.equals("bx") || extension.equals("bxm")) {
            if (filesProcessed.containsKey(extension)) {
                filesProcessed.put(extension, filesProcessed.get(extension) + 1);
            } else {
                filesProcessed.put(extension, 1);
            }
            return true;
        }
        return false;
    }
}

