/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.io.File;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.compiler.SourceMap;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyDefinition;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.runnables.IProxyRunnable;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public interface IBoxpiler {
    public static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    public static final Pattern FQNBasePattern = Pattern.compile("(.*?)(\\$Closure_.*|\\$Func_.*|\\$Lambda_.*)$");

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : array) {
                sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new BoxRuntimeException("Error compiling source", e);
        }
    }

    public Map<String, ClassInfo> getClassPool(String var1);

    public Class<IBoxRunnable> compileStatement(String var1, BoxSourceType var2);

    public Class<IBoxRunnable> compileScript(String var1, BoxSourceType var2);

    public Class<IBoxRunnable> compileTemplate(ResolvedFilePath var1);

    public List<byte[]> compileTemplateBytes(ResolvedFilePath var1);

    public Class<IBoxRunnable> compileClass(String var1, BoxSourceType var2);

    public Class<IBoxRunnable> compileClass(ResolvedFilePath var1);

    public Class<IProxyRunnable> compileInterfaceProxy(IBoxContext var1, InterfaceProxyDefinition var2);

    public ParsingResult parse(File var1);

    public ParsingResult parse(String var1, BoxSourceType var2, Boolean var3);

    public ParsingResult parseOrFail(File var1);

    public ParsingResult parseOrFail(String var1, BoxSourceType var2, Boolean var3);

    public ParsingResult validateParse(ParsingResult var1, String var2);

    public void printTranspiledCode(ParsingResult var1, ClassInfo var2, PrintStream var3);

    public SourceMap getSourceMapFromFQN(String var1);

    public static String getBaseFQN(String FQN2) {
        Matcher m = FQNBasePattern.matcher(FQN2);
        if (m.find()) {
            FQN2 = m.group(1);
        }
        return FQN2;
    }

    public void compileClassInfo(String var1, String var2);

    public void clearPagePool();
}

