/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import ortus.boxlang.runtime.types.util.JSONUtil;

public class SourceMap {
    public SourceMapRecord[] sourceMapRecords;
    public String source;
    private static Pattern isTemplate = Pattern.compile("(.cfs|.cfm|.bx|.bxs)$");

    public SourceMapRecord findClosestSourceMapRecord(int sourceLine) {
        SourceMapRecord found = null;
        int result = -1;
        int endOfClosestWrapper = -1;
        for (SourceMapRecord sourceMapRecord : this.sourceMapRecords) {
            if (sourceMapRecord.originSourceLineStart <= sourceLine && sourceMapRecord.originSourceLineEnd >= sourceLine) {
                result = sourceMapRecord.javaSourceLineStart;
                endOfClosestWrapper = sourceMapRecord.javaSourceLineEnd;
                found = sourceMapRecord;
                continue;
            }
            if (result > -1 && result > endOfClosestWrapper) break;
        }
        return found;
    }

    public String toJSON() {
        try {
            return JSONUtil.getJSONBuilder().asString(this);
        }
        catch (Exception e) {
            return "";
        }
    }

    public int convertSourceLineToJavaLine(int sourceLine) {
        int result = -1;
        int endOfClosestWrapper = -1;
        for (SourceMapRecord sourceMapRecord : this.sourceMapRecords) {
            if (sourceMapRecord.originSourceLineStart <= sourceLine && sourceMapRecord.originSourceLineEnd >= sourceLine) {
                result = sourceMapRecord.javaSourceLineStart;
                endOfClosestWrapper = sourceMapRecord.javaSourceLineEnd;
                continue;
            }
            if (result > -1 && result > endOfClosestWrapper) break;
        }
        return result;
    }

    public int convertJavaLineToSourceLine(int javaLine) {
        int result = -1;
        int endOfClosestWrapper = -1;
        List<SourceMapRecord> sortedSourceMapRecords = Arrays.asList(this.sourceMapRecords);
        sortedSourceMapRecords.sort((a, b) -> a.javaSourceLineStart - b.javaSourceLineStart);
        for (SourceMapRecord sourceMapRecord : sortedSourceMapRecords) {
            if (sourceMapRecord.javaSourceLineStart <= javaLine && sourceMapRecord.javaSourceLineEnd >= javaLine) {
                result = sourceMapRecord.originSourceLineStart;
                endOfClosestWrapper = sourceMapRecord.originSourceLineEnd;
                continue;
            }
            if (result <= -1 || result <= endOfClosestWrapper) continue;
            break;
        }
        return result;
    }

    public boolean isTemplate() {
        return isTemplate.matcher(this.source).find();
    }

    public String getFileName() {
        return Path.of(this.source, new String[0]).getFileName().toString();
    }

    public String getSource() {
        return this.source;
    }

    public static class SourceMapRecord {
        public int originSourceLineStart;
        public int originSourceLineEnd;
        public int javaSourceLineStart;
        public int javaSourceLineEnd;
        public String originSourceNode;
        public String javaSourceNode;
        public String javaSourceClassName;
    }
}

