/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.function.BiConsumer;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;
import ortus.boxlang.compiler.Boxpiler;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.visitor.QueryEscapeSingleQuoteVisitor;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class ASMBoxpiler
extends Boxpiler {
    public static final boolean DEBUG = Boolean.getBoolean("asmboxpiler.debug");
    private static ASMBoxpiler instance;

    private ASMBoxpiler() {
    }

    public static synchronized ASMBoxpiler getInstance() {
        if (instance == null) {
            instance = new ASMBoxpiler();
        }
        return instance;
    }

    @Override
    public void printTranspiledCode(ParsingResult result, ClassInfo classInfo, PrintStream target) {
        try (PrintWriter writer = new PrintWriter(target);){
            this.doCompileClassInfo(ASMBoxpiler.transpiler(classInfo), classInfo, this.parseClassInfo(classInfo).getRoot(), (fqn, node) -> node.accept(new TraceClassVisitor(null, writer)));
        }
    }

    @Override
    public void compileClassInfo(String classPoolName, String FQN2) {
        ClassInfo classInfo = this.getClassPool(classPoolName).get(FQN2);
        if (classInfo == null) {
            throw new BoxRuntimeException("ClassInfo not found for " + FQN2);
        }
        if (classInfo.resolvedFilePath() != null) {
            File sourceFile = classInfo.resolvedFilePath().absolutePath().toFile();
            if (this.diskClassUtil.isJavaBytecode(sourceFile)) {
                System.out.println("Loading bytecode direct from pre-compiled source file for " + FQN2);
                classInfo.getClassLoader().defineClasses(FQN2, sourceFile);
                return;
            }
            ParsingResult result = this.parseOrFail(sourceFile);
            this.doWriteClassInfo(result.getRoot(), classInfo);
        } else if (classInfo.source() != null) {
            ParsingResult result = this.parseOrFail(classInfo.source(), classInfo.sourceType(), classInfo.isClass());
            this.doWriteClassInfo(result.getRoot(), classInfo);
        } else {
            if (classInfo.interfaceProxyDefinition() != null) {
                throw new UnsupportedOperationException();
            }
            throw new BoxRuntimeException("Unknown class info type: " + classInfo.toString());
        }
    }

    private void doWriteClassInfo(BoxNode node, ClassInfo classInfo) {
        node.accept(new QueryEscapeSingleQuoteVisitor());
        this.doCompileClassInfo(ASMBoxpiler.transpiler(classInfo), classInfo, node, (fqn, classNode) -> {
            ClassWriter classWriter = new ClassWriter(2);
            if (DEBUG) {
                classNode.accept(new CheckClassAdapter(new TraceClassVisitor(classWriter, new PrintWriter(System.out))));
            } else {
                classNode.accept(classWriter);
            }
            byte[] bytes = classWriter.toByteArray();
            this.diskClassUtil.writeBytes(classInfo.classPoolName(), (String)fqn, "class", bytes);
        });
    }

    private static Transpiler transpiler(ClassInfo classInfo) {
        Transpiler transpiler = Transpiler.getTranspiler();
        transpiler.setProperty("classname", classInfo.className());
        transpiler.setProperty("packageName", classInfo.packageName().toString());
        transpiler.setProperty("boxFQN", classInfo.boxFqn().toString());
        transpiler.setProperty("baseclass", classInfo.baseclass());
        transpiler.setProperty("returnType", classInfo.returnType());
        transpiler.setProperty("sourceType", classInfo.sourceType().name());
        transpiler.setProperty("mappingName", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().mappingName());
        transpiler.setProperty("mappingPath", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().mappingPath());
        transpiler.setProperty("relativePath", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().relativePath());
        return transpiler;
    }

    private void doCompileClassInfo(Transpiler transpiler, ClassInfo classInfo, BoxNode node, BiConsumer<String, ClassNode> consumer) {
        ClassNode classNode;
        if (node instanceof BoxScript) {
            BoxScript boxScript = (BoxScript)node;
            classNode = transpiler.transpile(boxScript);
        } else if (node instanceof BoxClass) {
            BoxClass boxClass = (BoxClass)node;
            classNode = transpiler.transpile(boxClass);
        } else if (node instanceof BoxInterface) {
            BoxInterface boxInterface = (BoxInterface)node;
            classNode = transpiler.transpile(boxInterface);
        } else {
            throw new IllegalStateException("Unexpected root type: " + String.valueOf(node.getClass()) + ": " + String.valueOf(node));
        }
        transpiler.getAuxiliary().forEach(consumer);
        consumer.accept(classInfo.fqn().toString(), classNode);
    }

    private ParsingResult parseClassInfo(ClassInfo info) {
        if (info.resolvedFilePath() != null) {
            return this.parseOrFail(info.resolvedFilePath().absolutePath().toFile());
        }
        if (info.source() != null) {
            return this.parseOrFail(info.source(), info.sourceType(), info.isClass());
        }
        return null;
    }

    @Override
    public List<byte[]> compileTemplateBytes(ResolvedFilePath resolvedFilePath) {
        throw new UnsupportedOperationException("Unimplemented method 'compileTemplateBytes'");
    }
}

