/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import ortus.boxlang.compiler.asmboxpiler.ASMBoxpiler;
import ortus.boxlang.compiler.asmboxpiler.AsmTranspiler;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.AbstractFunction;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.DefaultExpression;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.MapHelper;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class AsmHelper {
    public static List<AbstractInsnNode> generateMapOfAbstractMethodNames(Transpiler transpiler, BoxNode classOrInterface) {
        List<List<AbstractInsnNode>> methodKeyLists = classOrInterface.getDescendantsOfType(BoxFunctionDeclaration.class).stream().filter(func -> func.getBody() == null).map(func -> {
            List<List<AbstractInsnNode>> absFunc = List.of(transpiler.createKey(func.getName()), AsmHelper.createAbstractFunction(transpiler, func));
            return absFunc;
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(AsmHelper.array(Type.getType(Object.class), methodKeyLists));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(MapHelper.class), "LinkedHashMapOfAny", Type.getMethodDescriptor(Type.getType(Map.class), Type.getType(Object[].class)), false));
        return nodes;
    }

    private static List<AbstractInsnNode> generateSetOfCompileTimeMethodNames(Transpiler transpiler, BoxClass boxClass) {
        List<List<AbstractInsnNode>> methodKeyLists = boxClass.getDescendantsOfType(BoxFunctionDeclaration.class).stream().map(BoxFunctionDeclaration::getName).map(transpiler::createKey).collect(Collectors.toList());
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(AsmHelper.array(Type.getType(Key.class), methodKeyLists));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Set.class), "of", Type.getMethodDescriptor(Type.getType(Set.class), Type.getType(Object[].class)), true));
        return nodes;
    }

    private static String getFunctionReturnType(BoxReturnType returnType) {
        if (returnType == null || returnType.getType() == null) {
            return "any";
        }
        if (returnType.getType().equals((Object)BoxType.Fqn)) {
            return returnType.getFqn();
        }
        return returnType.getType().name();
    }

    public static List<AbstractInsnNode> createAbstractFunction(Transpiler transpiler, BoxFunctionDeclaration func) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.add(new TypeInsnNode(187, Type.getInternalName(AbstractFunction.class)));
        nodes.add(new InsnNode(89));
        nodes.addAll(transpiler.createKey(func.getName()));
        List<List<AbstractInsnNode>> argList = func.getArgs().stream().map(arg -> transpiler.transform((BoxNode)arg, TransformerContext.NONE)).toList();
        nodes.addAll(AsmHelper.array(Type.getType(Argument.class), argList));
        nodes.add(new LdcInsnNode(AsmHelper.getFunctionReturnType(func.getType())));
        String accessModifier = "PUBLIC";
        if (func.getAccessModifier() != null) {
            accessModifier = func.getAccessModifier().name().toUpperCase();
        }
        nodes.add(new FieldInsnNode(178, Type.getInternalName(Function.Access.class), accessModifier, Type.getDescriptor(Function.Access.class)));
        nodes.add(new FieldInsnNode(178, Type.getInternalName(Struct.class), "EMPTY", Type.getDescriptor(IStruct.class)));
        nodes.add(new FieldInsnNode(178, Type.getInternalName(Struct.class), "EMPTY", Type.getDescriptor(IStruct.class)));
        nodes.add(new LdcInsnNode(transpiler.getProperty("boxClassName")));
        nodes.add(new LdcInsnNode("class"));
        nodes.add(new MethodInsnNode(183, Type.getInternalName(AbstractFunction.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Key.class), Type.getType(Argument[].class), Type.getType(String.class), Type.getType(Function.Access.class), Type.getType(IStruct.class), Type.getType(IStruct.class), Type.getType(String.class), Type.getType(String.class)), false));
        return nodes;
    }

    public static void addDebugLabel(List<AbstractInsnNode> nodes, String label) {
        if (!ASMBoxpiler.DEBUG) {
            return;
        }
        nodes.add(new LdcInsnNode(label));
        nodes.add(new InsnNode(87));
    }

    public static List<AbstractInsnNode> getDefaultExpression(AsmTranspiler transpiler, BoxExpression body) {
        Type type = Type.getType("L" + transpiler.getProperty("packageName").replace('.', '/') + "/" + transpiler.getProperty("classname") + "$Lambda_" + transpiler.incrementAndGetLambdaCounter() + ";");
        ClassNode classNode = new ClassNode();
        classNode.visit(61, 1, type.getInternalName(), null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(DefaultExpression.class)});
        MethodVisitor initVisitor = classNode.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        initVisitor.visitCode();
        initVisitor.visitVarInsn(25, 0);
        initVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
        initVisitor.visitInsn(177);
        initVisitor.visitEnd();
        MethodContextTracker t = new MethodContextTracker(false);
        transpiler.addMethodContextTracker(t);
        MethodVisitor methodVisitor = classNode.visitMethod(1, "evaluate", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class)), null, null);
        methodVisitor.visitCode();
        t.trackNewContext();
        transpiler.transform(body, TransformerContext.NONE, ReturnValueContext.VALUE_OR_NULL).forEach(ins -> ins.accept(methodVisitor));
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        transpiler.popMethodContextTracker();
        transpiler.setAuxiliary(type.getClassName(), classNode);
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.add(new TypeInsnNode(187, type.getInternalName()));
        nodes.add(new InsnNode(89));
        nodes.add(new MethodInsnNode(183, type.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false));
        return nodes;
    }

    public static List<AbstractInsnNode> callinvokeFunction(Transpiler transpiler, Type invokeType, List<BoxArgument> args, List<AbstractInsnNode> name, TransformerContext context, boolean safe) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(name);
        if (args.size() == 0 || args.get(0).getName() == null) {
            nodes.addAll(AsmHelper.array(Type.getType(Object.class), args, (argument, i) -> transpiler.transform((BoxNode)args.get((int)i), context, ReturnValueContext.VALUE)));
            nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "invokeFunction", Type.getMethodDescriptor(Type.getType(Object.class), invokeType, Type.getType(Object[].class)), true));
            return nodes;
        }
        List<List<AbstractInsnNode>> keyValues = args.stream().map(arg -> {
            List<List<AbstractInsnNode>> kv = List.of(transpiler.createKey(arg.getName()), transpiler.transform((BoxNode)arg, context, ReturnValueContext.VALUE));
            return kv;
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
        nodes.addAll(AsmHelper.array(Type.getType(Object.class), keyValues));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Struct.class), "of", Type.getMethodDescriptor(Type.getType(IStruct.class), Type.getType(Object[].class)), false));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "invokeFunction", Type.getMethodDescriptor(Type.getType(Object.class), invokeType, Type.getType(Map.class)), true));
        return nodes;
    }

    public static List<AbstractInsnNode> callReferencerGetAndInvoke(Transpiler transpiler, List<BoxArgument> args, String name, TransformerContext context, boolean safe) {
        return AsmHelper.callReferencerGetAndInvoke(transpiler, args, transpiler.createKey(name), context, safe);
    }

    public static List<AbstractInsnNode> callReferencerGetAndInvoke(Transpiler transpiler, List<BoxArgument> args, List<AbstractInsnNode> name, TransformerContext context, boolean safe) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(name);
        if (args.size() == 0 || args.get(0).getName() == null) {
            nodes.addAll(AsmHelper.array(Type.getType(Object.class), args, (argument, i) -> transpiler.transform((BoxNode)args.get((int)i), context, ReturnValueContext.VALUE)));
            nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), safe ? "TRUE" : "FALSE", Type.getDescriptor(Boolean.class)));
            nodes.add(new MethodInsnNode(184, Type.getInternalName(Referencer.class), "getAndInvoke", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(Key.class), Type.getType(Object[].class), Type.getType(Boolean.class)), false));
            return nodes;
        }
        List<List<AbstractInsnNode>> keyValues = args.stream().map(arg -> {
            List<List<AbstractInsnNode>> kv = List.of(transpiler.createKey(arg.getName()), transpiler.transform((BoxNode)arg, context, ReturnValueContext.VALUE));
            return kv;
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
        nodes.addAll(AsmHelper.array(Type.getType(Object.class), keyValues));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Struct.class), "of", Type.getMethodDescriptor(Type.getType(IStruct.class), Type.getType(Object[].class)), false));
        nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), safe ? "TRUE" : "FALSE", Type.getDescriptor(Boolean.class)));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Referencer.class), "getAndInvoke", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(Key.class), Type.getType(Map.class), Type.getType(Boolean.class)), false));
        return nodes;
    }

    public static List<AbstractInsnNode> callDynamicObjectInvokeConstructor(Transpiler transpiler, List<BoxArgument> args, TransformerContext context) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        if (args.size() == 0 || args.get(0).getName() == null) {
            nodes.addAll(AsmHelper.array(Type.getType(Object.class), args, (argument, i) -> transpiler.transform((BoxNode)args.get((int)i), context, ReturnValueContext.VALUE)));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(DynamicObject.class), "invokeConstructor", Type.getMethodDescriptor(Type.getType(DynamicObject.class), Type.getType(IBoxContext.class), Type.getType(Object[].class)), false));
            return nodes;
        }
        List<List<AbstractInsnNode>> keyValues = args.stream().map(arg -> {
            List<List<AbstractInsnNode>> kv = List.of(transpiler.createKey(arg.getName()), transpiler.transform((BoxNode)arg, context, ReturnValueContext.VALUE));
            return kv;
        }).flatMap(x -> x.stream()).collect(Collectors.toList());
        nodes.addAll(AsmHelper.array(Type.getType(Object.class), keyValues));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Struct.class), "of", Type.getMethodDescriptor(Type.getType(IStruct.class), Type.getType(Object[].class)), false));
        nodes.add(new MethodInsnNode(182, Type.getInternalName(DynamicObject.class), "invokeConstructor", Type.getMethodDescriptor(Type.getType(DynamicObject.class), Type.getType(IBoxContext.class), Type.getType(Map.class)), false));
        return nodes;
    }

    public static void init(ClassVisitor classVisitor, boolean singleton, Type type, Type superClass, Consumer<MethodVisitor> onConstruction, Type ... interfaces) {
        classVisitor.visit(61, 1, type.getInternalName(), null, superClass.getInternalName(), interfaces.length == 0 ? null : (String[])Arrays.stream(interfaces).map(Type::getInternalName).toArray(String[]::new));
        if (singleton) {
            AsmHelper.addGetInstance(classVisitor, type);
        }
        AsmHelper.addConstructor(classVisitor, !singleton, superClass, onConstruction);
        AsmHelper.addStaticFieldGetter(classVisitor, type, "compileVersion", "getRunnableCompileVersion", Type.LONG_TYPE, 1L);
        AsmHelper.addStaticFieldGetter(classVisitor, type, "compiledOn", "getRunnableCompiledOn", Type.getType(LocalDateTime.class), null);
        AsmHelper.addStaticFieldGetter(classVisitor, type, "ast", "getRunnableAST", Type.getType(Object.class), null);
    }

    private static void addConstructor(ClassVisitor classVisitor, boolean isPublic, Type superClass, Consumer<MethodVisitor> onConstruction) {
        MethodVisitor methodVisitor = classVisitor.visitMethod(isPublic ? 1 : 2, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, superClass.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
        onConstruction.accept(methodVisitor);
        methodVisitor.visitInsn(177);
        methodVisitor.visitEnd();
    }

    private static void addGetInstance(ClassVisitor classVisitor, Type type) {
        FieldVisitor fieldVisitor = classVisitor.visitField(10, "instance", type.getDescriptor(), null, null);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classVisitor.visitMethod(41, "getInstance", Type.getMethodDescriptor(type, new Type[0]), null, null);
        methodVisitor.visitCode();
        Label after = new Label();
        methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
        methodVisitor.visitJumpInsn(199, after);
        methodVisitor.visitTypeInsn(187, type.getInternalName());
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, type.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
        methodVisitor.visitFieldInsn(179, type.getInternalName(), "instance", type.getDescriptor());
        methodVisitor.visitLabel(after);
        methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static void addStaticFieldGetterWithStaticGetter(ClassVisitor classVisitor, Type type, String field, String method, String staticMethod, Type property, Object value) {
        AsmHelper.addStaticFieldGetterWithStaticGetter(classVisitor, type, field, method, staticMethod, property, value, true);
    }

    public static void addStaticFieldGetterWithStaticGetter(ClassVisitor classVisitor, Type type, String field, String method, String staticMethod, Type property, Object value, boolean isFinal) {
        AsmHelper.addStaticFieldGetter(classVisitor, type, field, method, property, value, isFinal);
        MethodVisitor methodVisitor = classVisitor.visitMethod(9, staticMethod, Type.getMethodDescriptor(property, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitFieldInsn(178, type.getInternalName(), field, property.getDescriptor());
        methodVisitor.visitInsn(property.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static void addStaticFieldGetter(ClassVisitor classVisitor, Type type, String field, String method, Type property, Object value) {
        AsmHelper.addStaticFieldGetter(classVisitor, type, field, method, property, value, true);
    }

    public static void addStaticFieldGetter(ClassVisitor classVisitor, Type type, String field, String method, Type property, Object value, boolean isFinal) {
        FieldVisitor fieldVisitor = classVisitor.visitField(8 | (isFinal ? 16 : 0) | 1, field, property.getDescriptor(), null, value);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, method, Type.getMethodDescriptor(property, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitFieldInsn(178, type.getInternalName(), field, property.getDescriptor());
        methodVisitor.visitInsn(property.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static void addFieldGetter(ClassVisitor classVisitor, Type type, String field, String method, Type property, Object value) {
        FieldVisitor fieldVisitor = classVisitor.visitField(2, field, property.getDescriptor(), null, value);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, method, Type.getMethodDescriptor(property, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, type.getInternalName(), field, property.getDescriptor());
        methodVisitor.visitInsn(property.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static void addPrviateStaticFieldGetter(ClassVisitor classVisitor, Type type, String field, String method, Type property, Object value) {
        FieldVisitor fieldVisitor = classVisitor.visitField(10, field, property.getDescriptor(), null, value);
        fieldVisitor.visitEnd();
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, method, Type.getMethodDescriptor(property, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(178, type.getInternalName(), field, property.getDescriptor());
        methodVisitor.visitInsn(property.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static void addFieldGetterAndSetter(ClassVisitor classVisitor, Type type, String field, String getter, String setter, Type property, Object value, Consumer<MethodVisitor> onAfterSet) {
        AsmHelper.addFieldGetter(classVisitor, type, field, getter, property, value);
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, setter, Type.getMethodDescriptor(Type.VOID_TYPE, property), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, type.getInternalName(), field, property.getDescriptor());
        onAfterSet.accept(methodVisitor);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static void complete(ClassVisitor classVisitor, Type type, Consumer<MethodVisitor> onCinit) {
        MethodVisitor methodVisitor = classVisitor.visitMethod(9, "<clinit>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(1L);
        methodVisitor.visitFieldInsn(179, type.getInternalName(), "compileVersion", Type.LONG_TYPE.getDescriptor());
        methodVisitor.visitLdcInsn(LocalDateTime.now().toString());
        methodVisitor.visitMethodInsn(184, Type.getInternalName(LocalDateTime.class), "parse", Type.getMethodDescriptor(Type.getType(LocalDateTime.class), Type.getType(CharSequence.class)), false);
        methodVisitor.visitFieldInsn(179, type.getInternalName(), "compiledOn", Type.getDescriptor(LocalDateTime.class));
        methodVisitor.visitInsn(1);
        methodVisitor.visitFieldInsn(179, type.getInternalName(), "ast", Type.getDescriptor(Object.class));
        onCinit.accept(methodVisitor);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static List<AbstractInsnNode> transformBodyExpressions(Transpiler transpiler, List<BoxStatement> statements, TransformerContext context, ReturnValueContext finalReturnValueContext) {
        if (statements.isEmpty()) {
            return new ArrayList<AbstractInsnNode>();
        }
        ReturnValueContext bodyContext = finalReturnValueContext == ReturnValueContext.VALUE_OR_NULL ? ReturnValueContext.EMPTY_UNLESS_JUMPING : ReturnValueContext.EMPTY;
        List<AbstractInsnNode> nodes = statements.stream().limit(statements.size() - 1).flatMap(child -> transpiler.transform((BoxNode)child, context, bodyContext).stream()).collect(Collectors.toList());
        BoxStatement lastStatement = statements.getLast();
        nodes.addAll(transpiler.transform(lastStatement, context, finalReturnValueContext));
        return nodes;
    }

    public static void methodWithContextAndClassLocator(ClassNode classNode, String name, Type parameterType, Type returnType, boolean isStatic, Transpiler transpiler, boolean implicityReturnNull, Supplier<List<AbstractInsnNode>> supplier) {
        MethodContextTracker tracker = new MethodContextTracker(isStatic);
        transpiler.addMethodContextTracker(tracker);
        MethodVisitor methodVisitor = classNode.visitMethod(1 | (isStatic ? 8 : 0), name, Type.getMethodDescriptor(returnType, parameterType), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, isStatic ? 0 : 1);
        tracker.trackNewContext().forEach(node -> node.accept(methodVisitor));
        methodVisitor.visitMethodInsn(184, Type.getInternalName(ClassLocator.class), "getInstance", Type.getMethodDescriptor(Type.getType(ClassLocator.class), new Type[0]), false);
        tracker.storeNewVariable(58).nodes().forEach(node -> node.accept(methodVisitor));
        List<AbstractInsnNode> nodes = supplier.get();
        if (!(nodes.isEmpty() || nodes.get(nodes.size() - 1).getOpcode() != 87 && nodes.get(nodes.size() - 1).getOpcode() != 88)) {
            nodes.subList(0, nodes.size() - 1).forEach(node -> node.accept(methodVisitor));
        } else {
            nodes.forEach(node -> node.accept(methodVisitor));
        }
        if (implicityReturnNull && !returnType.equals(Type.VOID_TYPE)) {
            methodVisitor.visitInsn(1);
        }
        methodVisitor.visitInsn(returnType.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        tracker.getTryCatchStack().stream().forEach(tryNode -> tryNode.accept(methodVisitor));
        tracker.clearTryCatchStack();
        methodVisitor.visitEnd();
        transpiler.popMethodContextTracker();
    }

    public static List<AbstractInsnNode> array(Type type, List<List<AbstractInsnNode>> values) {
        return AsmHelper.array(type, values, (abstractInsnNodes, i) -> abstractInsnNodes);
    }

    public static <T> List<AbstractInsnNode> array(Type type, List<T> values, BiFunction<T, Integer, List<AbstractInsnNode>> transformer) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.add(new LdcInsnNode((Object)values.size()));
        nodes.add(new TypeInsnNode(189, type.getInternalName()));
        for (int i = 0; i < values.size(); ++i) {
            nodes.add(new InsnNode(89));
            nodes.add(new LdcInsnNode((Object)i));
            List<AbstractInsnNode> toAdd = transformer.apply(values.get(i), i);
            if (toAdd.size() == 0) {
                nodes.add(new InsnNode(1));
            }
            nodes.addAll(toAdd);
            nodes.add(new InsnNode(83));
        }
        return nodes;
    }

    public static void addParentGetter(ClassNode classNode, Type declaringType, String name, String method, Type property) {
        MethodVisitor methodVisitor = classNode.visitMethod(1, method, Type.getMethodDescriptor(property, new Type[0]), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitFieldInsn(178, declaringType.getInternalName(), name, property.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitEnd();
    }

    public static void resolvedFilePath(MethodVisitor methodVisitor, String mappingName, String mappingPath, String relativePath, String filePath) {
        methodVisitor.visitLdcInsn(mappingName == null ? "" : mappingName);
        methodVisitor.visitLdcInsn(mappingPath == null ? "" : mappingPath);
        methodVisitor.visitLdcInsn(relativePath == null ? "" : relativePath);
        methodVisitor.visitLdcInsn(filePath);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(ResolvedFilePath.class), "of", Type.getMethodDescriptor(Type.getType(ResolvedFilePath.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class)), false);
    }

    public static void boxClassSupport(ClassVisitor classVisitor, String method, Type type, Type ... parameters) {
        MethodVisitor methodVisitor = classVisitor.visitMethod(1, method, Type.getMethodDescriptor(type, parameters), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        for (int index = 0; index < parameters.length; ++index) {
            methodVisitor.visitVarInsn(25, index + 1);
        }
        Type[] parametersAndThis = new Type[parameters.length + 1];
        parametersAndThis[0] = Type.getType(IClassRunnable.class);
        System.arraycopy(parameters, 0, parametersAndThis, 1, parameters.length);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(BoxClassSupport.class), method, Type.getMethodDescriptor(type, parametersAndThis), false);
        methodVisitor.visitInsn(type.getOpcode(172));
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    public static MethodNode dereferenceAndInvoke(String name, Type descriptor, Type type) {
        MethodNode node = new MethodNode(1, name, descriptor.getDescriptor(), null, null);
        node.visitCode();
        node.visitVarInsn(25, 0);
        node.visitTypeInsn(187, Type.getInternalName(ScriptingRequestBoxContext.class));
        node.visitInsn(89);
        node.visitMethodInsn(184, Type.getInternalName(BoxRuntime.class), "getInstance", Type.getMethodDescriptor(Type.getType(BoxRuntime.class), new Type[0]), false);
        node.visitMethodInsn(182, Type.getInternalName(BoxRuntime.class), "getRuntimeContext", Type.getMethodDescriptor(Type.getType(IBoxContext.class), new Type[0]), false);
        node.visitMethodInsn(183, Type.getInternalName(ScriptingRequestBoxContext.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class)), false);
        node.visitLdcInsn(name);
        node.visitMethodInsn(184, Type.getInternalName(Key.class), "of", Type.getMethodDescriptor(Type.getType(Key.class), Type.getType(String.class)), false);
        node.visitLdcInsn(descriptor.getArgumentCount());
        node.visitTypeInsn(189, Type.getInternalName(Object.class));
        int offset = 1;
        for (int index = 0; index < descriptor.getArgumentCount(); ++index) {
            node.visitInsn(89);
            node.visitLdcInsn(index);
            node.visitVarInsn(descriptor.getArgumentTypes()[index].getOpcode(21), offset);
            node.visitLdcInsn("DEBUG - ASMHelper 451");
            node.visitInsn(87);
            node.visitInsn(83);
            offset += descriptor.getArgumentTypes()[index].getSize();
        }
        node.visitFieldInsn(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class));
        node.visitMethodInsn(182, type.getInternalName(), "dereferenceAndInvoke", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Object.class), Type.getType(Boolean.class)), false);
        if (descriptor.getReturnType().getSort() == 0) {
            node.visitInsn(87);
        } else {
            node.visitTypeInsn(192, descriptor.getReturnType().getInternalName());
        }
        node.visitInsn(descriptor.getReturnType().getOpcode(172));
        node.visitMaxs(0, 0);
        node.visitEnd();
        return node;
    }

    public static void addLazySingleton(ClassVisitor classVisitor, Type type, Consumer<MethodVisitor> instantiation, Type ... arguments) {
        classVisitor.visitField(10, "instance", type.getDescriptor(), null, null).visitEnd();
        MethodVisitor methodVisitor = classVisitor.visitMethod(9, "getInstance", Type.getMethodDescriptor(type, arguments), null, null);
        methodVisitor.visitCode();
        Label endOfMethod = new Label();
        methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
        methodVisitor.visitJumpInsn(199, endOfMethod);
        methodVisitor.visitLdcInsn(type);
        methodVisitor.visitInsn(194);
        methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
        Label start = new Label();
        Label end = new Label();
        Label handler = new Label();
        methodVisitor.visitTryCatchBlock(start, end, handler, null);
        methodVisitor.visitLabel(start);
        methodVisitor.visitJumpInsn(199, end);
        instantiation.accept(methodVisitor);
        methodVisitor.visitLabel(end);
        methodVisitor.visitLdcInsn(type);
        methodVisitor.visitInsn(195);
        methodVisitor.visitLabel(endOfMethod);
        methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(handler);
        methodVisitor.visitLdcInsn(type);
        methodVisitor.visitInsn(195);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }
}

