/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import ortus.boxlang.compiler.ast.BoxNode;

public class MethodContextTracker {
    private int varCount = 0;
    private int unusedStackEntries = 0;
    private List<Integer> contextStack = new ArrayList<Integer>();
    private List<TryCatchBlockNode> tryCatchBlockNodes = new ArrayList<TryCatchBlockNode>();
    private Map<String, LabelNode> breaks = new LinkedHashMap<String, LabelNode>();
    private Map<String, LabelNode> continues = new LinkedHashMap<String, LabelNode>();
    private final CompilationType type;
    private Map<BoxNode, LabelNode> nodeBreaks = new LinkedHashMap<BoxNode, LabelNode>();
    private Map<BoxNode, LabelNode> nodeContinues = new LinkedHashMap<BoxNode, LabelNode>();
    private Map<String, BoxNode> stringLabel = new LinkedHashMap<String, BoxNode>();

    public MethodContextTracker(boolean isStatic) {
        this(CompilationType.BoxClass, isStatic);
    }

    public MethodContextTracker(CompilationType type, boolean isStatic) {
        this.type = type;
        this.varCount = isStatic ? -1 : 0;
    }

    public boolean canReturn() {
        return this.type == CompilationType.Function;
    }

    public void setStringLabel(String label, BoxNode target) {
        this.stringLabel.put(label, target);
    }

    public BoxNode getStringLabel(String label) {
        return this.stringLabel.get(label);
    }

    public void setBreak(BoxNode node, LabelNode label) {
        this.nodeBreaks.put(node, label);
    }

    public LabelNode getBreak(BoxNode node) {
        return this.nodeBreaks.get(node);
    }

    public void setContinue(BoxNode node, LabelNode label) {
        this.nodeContinues.put(node, label);
    }

    public LabelNode getContinue(BoxNode node) {
        return this.nodeContinues.get(node);
    }

    public LabelNode getCurrentBreak(String label) {
        return this.breaks.get(label == null ? "" : label);
    }

    public void setCurrentBreak(String label, LabelNode labelNode) {
        this.breaks.put(label == null ? "" : label, labelNode);
    }

    public void removeCurrentBreak(String label) {
        this.breaks.remove(label == null ? "" : label);
    }

    public LabelNode getCurrentContinue(String label) {
        return this.continues.get(label == null ? "" : label);
    }

    public void setCurrentContinue(String label, LabelNode labelNode) {
        this.continues.put(label == null ? "" : label, labelNode);
    }

    public void removeCurrentContinue(String label) {
        this.continues.remove(label == null ? "" : label);
    }

    public List<TryCatchBlockNode> getTryCatchStack() {
        return this.tryCatchBlockNodes;
    }

    public void addTryCatchBlock(TryCatchBlockNode tryCatchBlockNode) {
        this.tryCatchBlockNodes.add(tryCatchBlockNode);
    }

    public void clearTryCatchStack() {
        this.tryCatchBlockNodes = new ArrayList<TryCatchBlockNode>();
    }

    public int getUnusedStackCount() {
        return this.unusedStackEntries;
    }

    public void trackUnusedStackEntry() {
        ++this.unusedStackEntries;
    }

    public void clearStackCounter() {
        this.unusedStackEntries = 0;
    }

    public int getCurrentStackHeight() {
        return this.unusedStackEntries;
    }

    public void decrementStackCounter(int amount) {
        this.unusedStackEntries -= amount;
    }

    public List<AbstractInsnNode> popAllStackEntries() {
        return this.popStackEntries(this.unusedStackEntries);
    }

    public List<AbstractInsnNode> popStackEntries(int numberToPop) {
        if (this.unusedStackEntries == 0) {
            return new ArrayList<AbstractInsnNode>();
        }
        this.unusedStackEntries -= numberToPop;
        return IntStream.range(0, numberToPop).mapToObj(i -> new InsnNode(87)).toList();
    }

    public VarStore storeNewVariable(int opcode) {
        ++this.varCount;
        return new VarStore(this.varCount, List.of(new VarInsnNode(opcode, this.varCount)));
    }

    public List<AbstractInsnNode> trackNewContext() {
        VarStore res = this.storeNewVariable(58);
        this.contextStack.add(res.index);
        return res.nodes;
    }

    public void popContext() {
        this.contextStack.removeLast();
    }

    public List<AbstractInsnNode> loadCurrentContext() {
        return List.of(new VarInsnNode(25, this.contextStack.getLast()));
    }

    public static enum CompilationType {
        BoxClass,
        Component,
        Function;

    }

    public record VarStore(int index, List<AbstractInsnNode> nodes) {
    }
}

