/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.AsmTranspiler;
import ortus.boxlang.compiler.asmboxpiler.ITranspiler;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.statement.BoxInterfaceTransformer;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStaticInitializer;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public abstract class Transpiler
implements ITranspiler {
    private final HashMap<String, String> properties = new HashMap();
    private Map<String, BoxExpression> keys = new LinkedHashMap<String, BoxExpression>();
    private Map<String, ClassNode> auxiliaries = new LinkedHashMap<String, ClassNode>();
    private List<TryCatchBlockNode> tryCatchBlockNodes = new ArrayList<TryCatchBlockNode>();
    private int lambdaCounter = 0;
    private int componentCounter = 0;
    private int functionBodyCounter = 0;
    private Map<String, LabelNode> breaks = new LinkedHashMap<String, LabelNode>();
    private Map<String, LabelNode> continues = new LinkedHashMap<String, LabelNode>();
    private List<ImportDefinition> imports = new ArrayList<ImportDefinition>();
    private List<MethodContextTracker> methodContextTrackers = new ArrayList<MethodContextTracker>();
    private List<BoxStaticInitializer> staticInitializers = new ArrayList<BoxStaticInitializer>();

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public boolean canReturn() {
        return this.functionBodyCounter > 0;
    }

    public void incrementfunctionBodyCounter() {
        ++this.functionBodyCounter;
    }

    public void decrementfunctionBodyCounter() {
        --this.functionBodyCounter;
    }

    public boolean isInsideComponent() {
        return this.componentCounter > 0;
    }

    public int getComponentCounter() {
        return this.componentCounter;
    }

    public void setComponentCounter(int counter) {
        this.componentCounter = counter;
    }

    public void incrementComponentCounter() {
        ++this.componentCounter;
    }

    public void decrementComponentCounter() {
        --this.componentCounter;
    }

    public ClassNode transpile(BoxInterface boxClass) throws BoxRuntimeException {
        return BoxInterfaceTransformer.transpile(this, boxClass);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public static Transpiler getTranspiler() {
        return new AsmTranspiler();
    }

    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context) {
        return this.transform(node, context, ReturnValueContext.EMPTY);
    }

    public abstract List<AbstractInsnNode> transform(BoxNode var1, TransformerContext var2, ReturnValueContext var3);

    public int registerKey(BoxExpression key) {
        String name;
        if (key instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)key;
            name = str.getValue();
        } else if (key instanceof BoxIntegerLiteral) {
            BoxIntegerLiteral intr = (BoxIntegerLiteral)key;
            name = intr.getValue();
        } else {
            throw new IllegalStateException("Key must be a string or integer literal");
        }
        if (this.keys.containsKey(name)) {
            return new ArrayList<String>(this.keys.keySet()).indexOf(name);
        }
        this.keys.put(name, key);
        return this.keys.size() - 1;
    }

    public Map<String, BoxExpression> getKeys() {
        return this.keys;
    }

    public Optional<MethodContextTracker> getCurrentMethodContextTracker() {
        return this.methodContextTrackers.size() > 0 ? Optional.of(this.methodContextTrackers.getLast()) : Optional.empty();
    }

    public void addMethodContextTracker(MethodContextTracker methodContextTracker) {
        this.methodContextTrackers.add(methodContextTracker);
    }

    public void popMethodContextTracker() {
        this.methodContextTrackers.removeLast();
    }

    public List<TryCatchBlockNode> getTryCatchStack() {
        return this.tryCatchBlockNodes;
    }

    public void addTryCatchBlock(TryCatchBlockNode tryCatchBlockNode) {
        this.tryCatchBlockNodes.add(tryCatchBlockNode);
    }

    public void clearTryCatchStack() {
        this.tryCatchBlockNodes = new ArrayList<TryCatchBlockNode>();
    }

    public void addBoxStaticInitializer(BoxStaticInitializer staticInitializer) {
        this.staticInitializers.add(staticInitializer);
    }

    public List<BoxStaticInitializer> getBoxStaticInitializers() {
        return this.staticInitializers;
    }

    public Map<String, ClassNode> getAuxiliary() {
        return this.auxiliaries;
    }

    public void setAuxiliary(String name, ClassNode classNode) {
        if (this.auxiliaries.putIfAbsent(name, classNode) != null) {
            // empty if block
        }
    }

    public int incrementAndGetLambdaCounter() {
        return ++this.lambdaCounter;
    }

    public List<AbstractInsnNode> createKey(BoxExpression expr) {
        if (expr instanceof BoxStringLiteral || expr instanceof BoxIntegerLiteral) {
            int pos = this.registerKey(expr);
            return List.of(new FieldInsnNode(178, this.getProperty("packageName").replace('.', '/') + "/" + this.getProperty("classname"), "keys", Type.getDescriptor(Key[].class)), new LdcInsnNode((Object)pos), new InsnNode(50));
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(this.transform(expr, TransformerContext.NONE, ReturnValueContext.VALUE));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Key.class), "of", Type.getMethodDescriptor(Type.getType(Key.class), Type.getType(Object.class)), false));
        return nodes;
    }

    public abstract List<List<AbstractInsnNode>> transformProperties(Type var1, List<BoxProperty> var2, String var3);

    public List<AbstractInsnNode> createKey(String expr) {
        return this.createKey(new BoxStringLiteral(expr, null, expr));
    }

    public List<AbstractInsnNode> transformDocumentation(List<BoxDocumentationAnnotation> documentation) {
        ArrayList<List<AbstractInsnNode>> members = new ArrayList<List<AbstractInsnNode>>();
        documentation.forEach(doc -> {
            List<AbstractInsnNode> annotationKey = this.createKey(doc.getKey().getValue());
            members.add(annotationKey);
            List<AbstractInsnNode> value = this.transform(doc.getValue(), TransformerContext.NONE, ReturnValueContext.EMPTY);
            members.add(value);
        });
        if (members.isEmpty()) {
            return List.of(new FieldInsnNode(178, Type.getInternalName(Struct.class), "EMPTY", Type.getDescriptor(IStruct.class)));
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(AsmHelper.array(Type.getType(Object.class), members));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Struct.class), "linkedOf", Type.getMethodDescriptor(Type.getType(IStruct.class), Type.getType(Object[].class)), false));
        return nodes;
    }

    public List<AbstractInsnNode> transformAnnotations(List<BoxAnnotation> annotations, Boolean defaultTrue, boolean onlyLiteralValues) {
        ArrayList<List<AbstractInsnNode>> members = new ArrayList<List<AbstractInsnNode>>();
        annotations.forEach(annotation -> {
            List<AbstractInsnNode> annotationKey = this.createKey(annotation.getKey().getValue());
            members.add(annotationKey);
            BoxExpression thisValue = annotation.getValue();
            List<AbstractInsnNode> value = thisValue != null ? (thisValue.isLiteral() ? this.transform(thisValue, TransformerContext.NONE, ReturnValueContext.VALUE) : (onlyLiteralValues ? List.of(new LdcInsnNode("<Runtime Expression>")) : this.transform(thisValue, TransformerContext.NONE, ReturnValueContext.VALUE))) : (defaultTrue != false ? List.of(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class))) : List.of(new LdcInsnNode("")));
            members.add(value);
        });
        if (annotations.isEmpty()) {
            return List.of(new TypeInsnNode(187, Type.getInternalName(Struct.class)), new InsnNode(89), new MethodInsnNode(183, Type.getInternalName(Struct.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false));
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(AsmHelper.array(Type.getType(Object.class), members));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Struct.class), "linkedOf", Type.getMethodDescriptor(Type.getType(IStruct.class), Type.getType(Object[].class)), false));
        return nodes;
    }

    public List<AbstractInsnNode> transformAnnotations(List<BoxAnnotation> annotations) {
        return this.transformAnnotations(annotations, false, true);
    }

    public void addImport(BoxExpression expression, BoxIdentifier alias) {
        this.imports.add(ImportDefinition.parse((String)(alias == null ? expression.toString() : String.valueOf(expression) + " as " + alias.getName())));
    }

    public List<List<AbstractInsnNode>> getImports() {
        return this.imports.stream().map(anImport -> List.of(new LdcInsnNode(anImport.className() + " as " + anImport.alias()))).toList();
    }

    public boolean matchesImport(String token) {
        return this.imports.stream().anyMatch(i -> token.equalsIgnoreCase(i.alias()) || token.equalsIgnoreCase(i.className()));
    }
}

