/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxAccess;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.scopes.Key;

public class BoxAccessTransformer
extends AbstractTransformer {
    public BoxAccessTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxFunctionInvocation bfun;
        BoxArgument barg;
        BoxNode boxNode;
        ArrayList<AbstractInsnNode> nodes;
        List<AbstractInsnNode> accessKey;
        BoxAccess objectAccess = (BoxAccess)node;
        Boolean safe = objectAccess.isSafe() != false || context == TransformerContext.SAFE;
        if (objectAccess instanceof BoxDotAccess) {
            BoxDotAccess dotAccess = (BoxDotAccess)objectAccess;
            BoxExpression boxExpression = dotAccess.getAccess();
            if (boxExpression instanceof BoxIdentifier) {
                BoxIdentifier id = (BoxIdentifier)boxExpression;
                accessKey = this.transpiler.createKey(id.getName());
            } else {
                boxExpression = dotAccess.getAccess();
                if (!(boxExpression instanceof BoxIntegerLiteral)) throw new IllegalStateException("Unsupported access type: " + dotAccess.getAccess().getClass().getName());
                BoxIntegerLiteral il = (BoxIntegerLiteral)boxExpression;
                accessKey = this.transpiler.createKey(il);
            }
        } else {
            accessKey = this.transpiler.createKey(objectAccess.getAccess());
        }
        if (objectAccess.getContext() instanceof BoxScope) {
            nodes = new ArrayList<AbstractInsnNode>();
            nodes.addAll(this.transpiler.transform(objectAccess.getContext(), TransformerContext.NONE, ReturnValueContext.VALUE));
            nodes.add(new VarInsnNode(25, 1));
            nodes.addAll(accessKey);
            nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), safe.toString().toUpperCase(), Type.getDescriptor(Boolean.class)));
            nodes.add(new MethodInsnNode(185, Type.getInternalName(IReferenceable.class), "dereference", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Boolean.class)), true));
            return nodes;
        }
        nodes = new ArrayList();
        nodes.add(new VarInsnNode(25, 1));
        nodes.addAll(this.transpiler.transform(objectAccess.getContext(), context, ReturnValueContext.VALUE));
        nodes.addAll(accessKey);
        nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), safe.toString().toUpperCase(), Type.getDescriptor(Boolean.class)));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Referencer.class), "get", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(Key.class), Type.getType(Boolean.class)), false));
        BoxNode parent = objectAccess.getParent();
        if (parent instanceof BoxAccess || parent instanceof BoxArgument && (boxNode = (barg = (BoxArgument)parent).getParent()) instanceof BoxFunctionInvocation && (bfun = (BoxFunctionInvocation)boxNode).getName().toLowerCase().contains("array")) return nodes;
        nodes.add(0, new VarInsnNode(25, 1));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "unwrapQueryColumn", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class)), true));
        return nodes;
    }
}

