/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.AsmTranspiler;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxAccess;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.ExpressionInterpreter;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.operators.Concat;
import ortus.boxlang.runtime.operators.Divide;
import ortus.boxlang.runtime.operators.Minus;
import ortus.boxlang.runtime.operators.Modulus;
import ortus.boxlang.runtime.operators.Multiply;
import ortus.boxlang.runtime.operators.Plus;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxAssignmentTransformer
extends AbstractTransformer {
    public BoxAssignmentTransformer(AsmTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxAssignment assigment = (BoxAssignment)node;
        List<AbstractInsnNode> nodes = null;
        if (assigment.getOp() == BoxAssignmentOperator.Equal) {
            List<AbstractInsnNode> jRight = this.transpiler.transform(assigment.getRight(), TransformerContext.NONE, ReturnValueContext.VALUE);
            nodes = this.transformEquals(assigment.getLeft(), jRight, assigment.getOp(), assigment.getModifiers());
        } else {
            nodes = this.transformCompoundEquals(assigment);
        }
        if (returnContext.empty) {
            nodes.add(new InsnNode(87));
        }
        return nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<AbstractInsnNode> transformEquals(BoxExpression left, List<AbstractInsnNode> jRight, BoxAssignmentOperator op, List<BoxAssignmentModifier> modifiers) throws IllegalStateException {
        BoxIdentifier id;
        BoxScope scope;
        boolean hasVar = this.hasVar(modifiers);
        boolean hasStatic = this.hasStatic(modifiers);
        boolean hasFinal = this.hasFinal(modifiers);
        String mustBeScopeName = null;
        Optional<MethodContextTracker> tracker = this.transpiler.getCurrentMethodContextTracker();
        if (left instanceof BoxStringInterpolation || left instanceof BoxStringLiteral) {
            if (hasVar) {
                throw new ExpressionException("You cannot use the [var] keyword with a quoted string on the left hand side of your assignment", left.getPosition(), left.getSourceText());
            }
            if (hasStatic) {
                throw new ExpressionException("You cannot use the [static] keyword with a quoted string on the left hand side of your assignment", left.getPosition(), left.getSourceText());
            }
            ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.addAll(this.transpiler.transform(left, null));
            nodes.addAll(jRight);
            nodes.add(new MethodInsnNode(184, Type.getInternalName(ExpressionInterpreter.class), "setVariable", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(String.class), Type.getType(Object.class)), false));
            return nodes;
        }
        ArrayList<List<AbstractInsnNode>> accessKeys = new ArrayList<List<AbstractInsnNode>>();
        BoxExpression furthestLeft = left;
        while (furthestLeft instanceof BoxAccess) {
            BoxAccess currentObjectAccess = (BoxAccess)furthestLeft;
            if (currentObjectAccess instanceof BoxDotAccess) {
                BoxDotAccess dotAccess = (BoxDotAccess)currentObjectAccess;
                BoxExpression boxExpression = dotAccess.getAccess();
                if (boxExpression instanceof BoxIdentifier) {
                    BoxIdentifier id2 = (BoxIdentifier)boxExpression;
                    accessKeys.add(0, this.transpiler.createKey(id2.getName()));
                } else {
                    boxExpression = dotAccess.getAccess();
                    if (!(boxExpression instanceof BoxIntegerLiteral)) throw new ExpressionException("Unexpected element [" + currentObjectAccess.getAccess().getClass().getSimpleName() + "] in dot access expression.", currentObjectAccess.getAccess().getPosition(), currentObjectAccess.getAccess().getSourceText());
                    BoxIntegerLiteral intl = (BoxIntegerLiteral)boxExpression;
                    accessKeys.add(0, this.transpiler.createKey(intl.getValue()));
                }
            } else {
                accessKeys.add(0, this.transpiler.createKey(currentObjectAccess.getAccess()));
            }
            furthestLeft = currentObjectAccess.getContext();
        }
        if (hasStatic && hasVar) {
            throw new ExpressionException("You cannot use the [var] and [static] keywords together", left.getPosition(), left.getSourceText());
        }
        if (hasVar) {
            mustBeScopeName = "local";
            if (furthestLeft instanceof BoxScope) {
                scope = (BoxScope)furthestLeft;
                accessKeys.add(0, this.transpiler.createKey(scope.getName()));
            } else {
                if (!(furthestLeft instanceof BoxIdentifier)) throw new ExpressionException("You cannot use the [var] keyword before " + furthestLeft.getClass().getSimpleName(), furthestLeft.getPosition(), furthestLeft.getSourceText());
                id = (BoxIdentifier)furthestLeft;
                accessKeys.add(0, this.transpiler.createKey(id.getName()));
            }
            furthestLeft = new BoxIdentifier("local", null, null);
        }
        if (hasStatic) {
            mustBeScopeName = "static";
            if (furthestLeft instanceof BoxScope) {
                scope = (BoxScope)furthestLeft;
                accessKeys.add(0, this.transpiler.createKey(scope.getName()));
            } else {
                if (!(furthestLeft instanceof BoxIdentifier)) throw new ExpressionException("You cannot use the [static] keyword before " + furthestLeft.getClass().getSimpleName(), furthestLeft.getPosition(), furthestLeft.getSourceText());
                id = (BoxIdentifier)furthestLeft;
                accessKeys.add(0, this.transpiler.createKey(id.getName()));
            }
            furthestLeft = new BoxIdentifier("static", null, null);
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        if (furthestLeft instanceof BoxIdentifier) {
            BoxIdentifier id3 = (BoxIdentifier)furthestLeft;
            if (this.transpiler.matchesImport(id3.getName()) && this.transpiler.getProperty("sourceType").toLowerCase().startsWith("box")) {
                throw new ExpressionException("You cannot assign a variable with the same name as an import: [" + id3.getName() + "]", furthestLeft.getPosition(), furthestLeft.getSourceText());
            }
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), hasFinal ? "TRUE" : "FALSE", Type.getDescriptor(Boolean.class)));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
            if (mustBeScopeName != null) {
                nodes.addAll(this.transpiler.createKey(mustBeScopeName));
            } else {
                nodes.add(new InsnNode(1));
            }
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.addAll(this.transpiler.createKey(id3.getName()));
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "getDefaultAssignmentScope", Type.getMethodDescriptor(Type.getType(IScope.class), new Type[0]), true));
            nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "scopeFindNearby", Type.getMethodDescriptor(Type.getType(IBoxContext.ScopeSearchResult.class), Type.getType(Key.class), Type.getType(IScope.class)), true));
            nodes.addAll(jRight);
            nodes.addAll(AsmHelper.array(Type.getType(Key.class), accessKeys));
            nodes.add(new MethodInsnNode(184, Type.getInternalName(Referencer.class), "setDeep", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.BOOLEAN_TYPE, Type.getType(Key.class), Type.getType(IBoxContext.ScopeSearchResult.class), Type.getType(Object.class), Type.getType(Key[].class)), false));
            return nodes;
        } else {
            if (accessKeys.size() == 0) {
                throw new ExpressionException("You cannot assign a value to " + left.getClass().getSimpleName(), left.getPosition(), left.getSourceText());
            }
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), hasFinal ? "TRUE" : "FALSE", Type.getDescriptor(Boolean.class)));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
            if (mustBeScopeName != null) {
                nodes.addAll(this.transpiler.createKey(mustBeScopeName));
            } else {
                nodes.add(new InsnNode(1));
            }
            nodes.addAll(this.transpiler.transform(furthestLeft, TransformerContext.NONE, ReturnValueContext.VALUE));
            nodes.addAll(jRight);
            nodes.addAll(AsmHelper.array(Type.getType(Key.class), accessKeys));
            nodes.add(new MethodInsnNode(184, Type.getInternalName(Referencer.class), "setDeep", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.BOOLEAN_TYPE, Type.getType(Key.class), Type.getType(Object.class), Type.getType(Object.class), Type.getType(Key[].class)), false));
        }
        return nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<AbstractInsnNode> transformCompoundEquals(BoxAssignment assigment) throws IllegalStateException {
        Optional<MethodContextTracker> tracker = this.transpiler.getCurrentMethodContextTracker();
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        List<AbstractInsnNode> right = this.transpiler.transform(assigment.getRight(), TransformerContext.NONE);
        tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
        BoxExpression boxExpression = assigment.getLeft();
        if (boxExpression instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)boxExpression;
            accessKey = this.transpiler.createKey(id.getName());
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.addAll((Collection<AbstractInsnNode>)accessKey);
            tracker.ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
            nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "getDefaultAssignmentScope", Type.getMethodDescriptor(Type.getType(IScope.class), new Type[0]), true));
            nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "scopeFindNearby", Type.getMethodDescriptor(Type.getType(IBoxContext.ScopeSearchResult.class), Type.getType(Key.class), Type.getType(IScope.class)), true));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(IBoxContext.ScopeSearchResult.class), "scope", Type.getMethodDescriptor(Type.getType(IReferenceable.class), new Type[0]), false));
            nodes.addAll((Collection<AbstractInsnNode>)accessKey);
        } else {
            accessKey = assigment.getLeft();
            if (!(accessKey instanceof BoxAccess)) throw new ExpressionException("You cannot assign a value to " + assigment.getLeft().getClass().getSimpleName(), assigment.getPosition(), assigment.getSourceText());
            BoxAccess objectAccess = (BoxAccess)accessKey;
            nodes.addAll(this.transpiler.transform(objectAccess.getContext(), TransformerContext.NONE));
            if (objectAccess instanceof BoxDotAccess) {
                BoxDotAccess dotAccess = (BoxDotAccess)objectAccess;
                BoxExpression boxExpression2 = dotAccess.getAccess();
                if (boxExpression2 instanceof BoxIdentifier) {
                    BoxIdentifier id = (BoxIdentifier)boxExpression2;
                    accessKey = this.transpiler.createKey(id.getName());
                } else {
                    boxExpression2 = dotAccess.getAccess();
                    if (!(boxExpression2 instanceof BoxIntegerLiteral)) throw new ExpressionException("Unexpected element [" + dotAccess.getAccess().getClass().getSimpleName() + "] in dot access expression.", dotAccess.getAccess().getPosition(), dotAccess.getAccess().getSourceText());
                    BoxIntegerLiteral intl = (BoxIntegerLiteral)boxExpression2;
                    accessKey = this.transpiler.createKey(intl.getValue());
                }
            } else {
                accessKey = this.transpiler.createKey(objectAccess.getAccess());
            }
            nodes.addAll((Collection<AbstractInsnNode>)accessKey);
        }
        nodes.addAll(right);
        nodes.add(new MethodInsnNode(184, Type.getInternalName(this.getMethodCallTemplate(assigment)), "invoke", Type.getMethodDescriptor(Type.getType(assigment.getOp() == BoxAssignmentOperator.ConcatEqual ? String.class : Number.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(Key.class), Type.getType(Object.class)), false));
        return nodes;
    }

    private boolean hasVar(List<BoxAssignmentModifier> modifiers) {
        return modifiers.stream().anyMatch(it -> it == BoxAssignmentModifier.VAR);
    }

    private boolean hasStatic(List<BoxAssignmentModifier> modifiers) {
        return modifiers.stream().anyMatch(it -> it == BoxAssignmentModifier.STATIC);
    }

    private boolean hasFinal(List<BoxAssignmentModifier> modifiers) {
        return modifiers.stream().anyMatch(it -> it == BoxAssignmentModifier.FINAL);
    }

    private Class<?> getMethodCallTemplate(BoxAssignment assignment) {
        BoxAssignmentOperator operator = assignment.getOp();
        return switch (operator) {
            case BoxAssignmentOperator.PlusEqual -> Plus.class;
            case BoxAssignmentOperator.MinusEqual -> Minus.class;
            case BoxAssignmentOperator.StarEqual -> Multiply.class;
            case BoxAssignmentOperator.SlashEqual -> Divide.class;
            case BoxAssignmentOperator.ModEqual -> Modulus.class;
            case BoxAssignmentOperator.ConcatEqual -> Concat.class;
            default -> throw new ExpressionException("Unknown assingment operator " + operator.toString(), assignment.getPosition(), assignment.getSourceText());
        };
    }
}

