/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperator;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.operators.BitwiseAnd;
import ortus.boxlang.runtime.operators.BitwiseOr;
import ortus.boxlang.runtime.operators.BitwiseSignedLeftShift;
import ortus.boxlang.runtime.operators.BitwiseSignedRightShift;
import ortus.boxlang.runtime.operators.BitwiseUnsignedRightShift;
import ortus.boxlang.runtime.operators.BitwiseXor;
import ortus.boxlang.runtime.operators.CastAs;
import ortus.boxlang.runtime.operators.Contains;
import ortus.boxlang.runtime.operators.Divide;
import ortus.boxlang.runtime.operators.Elvis;
import ortus.boxlang.runtime.operators.Equivalence;
import ortus.boxlang.runtime.operators.Implies;
import ortus.boxlang.runtime.operators.InstanceOf;
import ortus.boxlang.runtime.operators.IntegerDivide;
import ortus.boxlang.runtime.operators.Minus;
import ortus.boxlang.runtime.operators.Modulus;
import ortus.boxlang.runtime.operators.Multiply;
import ortus.boxlang.runtime.operators.NotContains;
import ortus.boxlang.runtime.operators.Plus;
import ortus.boxlang.runtime.operators.Power;
import ortus.boxlang.runtime.operators.XOR;

public class BoxBinaryOperationTransformer
extends AbstractTransformer {
    public BoxBinaryOperationTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxBinaryOperation operation = (BoxBinaryOperation)node;
        TransformerContext safe = operation.getOperator() == BoxBinaryOperator.Elvis ? TransformerContext.SAFE : context;
        List<AbstractInsnNode> left = this.transpiler.transform(operation.getLeft(), safe, ReturnValueContext.VALUE);
        List<AbstractInsnNode> right = this.transpiler.transform(operation.getRight(), context, ReturnValueContext.VALUE);
        List<AbstractInsnNode> nodes = switch (operation.getOperator()) {
            case BoxBinaryOperator.Plus -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Plus.class, Number.class, left, right);
            case BoxBinaryOperator.Minus -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Minus.class, Number.class, left, right);
            case BoxBinaryOperator.Star -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Multiply.class, Number.class, left, right);
            case BoxBinaryOperator.Slash -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Divide.class, Number.class, left, right);
            case BoxBinaryOperator.Backslash -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(IntegerDivide.class, Number.class, left, right);
            case BoxBinaryOperator.Power -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Power.class, Number.class, left, right);
            case BoxBinaryOperator.Xor -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(XOR.class, Boolean.class, left, right);
            case BoxBinaryOperator.Mod -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Modulus.class, Number.class, left, right);
            case BoxBinaryOperator.And -> {
                LabelNode ifFalse = new LabelNode();
                LabelNode end = new LabelNode();
                ArrayList<AbstractInsnNode> expression = new ArrayList<AbstractInsnNode>();
                expression.addAll(left);
                expression.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
                expression.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
                expression.add(new JumpInsnNode(153, ifFalse));
                expression.addAll(right);
                expression.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
                expression.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
                expression.add(new JumpInsnNode(153, ifFalse));
                expression.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
                expression.add(new JumpInsnNode(167, end));
                expression.add(ifFalse);
                expression.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
                expression.add(end);
                yield expression;
            }
            case BoxBinaryOperator.Or -> {
                LabelNode ifTrue = new LabelNode();
                LabelNode end = new LabelNode();
                ArrayList<AbstractInsnNode> expression = new ArrayList();
                expression.addAll(left);
                expression.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
                expression.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
                expression.add(new JumpInsnNode(154, ifTrue));
                expression.addAll(right);
                expression.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
                expression.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
                expression.add(new JumpInsnNode(154, ifTrue));
                expression.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "FALSE", Type.getDescriptor(Boolean.class)));
                expression.add(new JumpInsnNode(167, end));
                expression.add(ifTrue);
                expression.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), "TRUE", Type.getDescriptor(Boolean.class)));
                expression.add(end);
                yield expression;
            }
            case BoxBinaryOperator.Equivalence -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Equivalence.class, Object.class, left, right);
            case BoxBinaryOperator.Implies -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Implies.class, Object.class, left, right);
            case BoxBinaryOperator.Elvis -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Elvis.class, Object.class, left, right);
            case BoxBinaryOperator.InstanceOf -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodesWithContext(InstanceOf.class, Boolean.class, left, right);
            case BoxBinaryOperator.Contains -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(Contains.class, Boolean.class, left, right);
            case BoxBinaryOperator.NotContains -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(NotContains.class, Boolean.class, left, right);
            case BoxBinaryOperator.CastAs -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodesWithContext(CastAs.class, Object.class, left, right);
            case BoxBinaryOperator.BitwiseAnd -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(BitwiseAnd.class, Number.class, left, right);
            case BoxBinaryOperator.BitwiseOr -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(BitwiseOr.class, Number.class, left, right);
            case BoxBinaryOperator.BitwiseXor -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(BitwiseXor.class, Number.class, left, right);
            case BoxBinaryOperator.BitwiseSignedLeftShift -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(BitwiseSignedLeftShift.class, Number.class, left, right);
            case BoxBinaryOperator.BitwiseSignedRightShift -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(BitwiseSignedRightShift.class, Number.class, left, right);
            case BoxBinaryOperator.BitwiseUnsignedRightShift -> BoxBinaryOperationTransformer.generateBinaryMethodCallNodes(BitwiseUnsignedRightShift.class, Number.class, left, right);
            default -> throw new IllegalStateException("not implemented");
        };
        if (returnContext.empty) {
            nodes.add(new InsnNode(87));
        }
        return nodes;
    }

    @Nonnull
    private static List<AbstractInsnNode> generateBinaryMethodCallNodes(Class<?> dispatcher, Class<?> returned, List<AbstractInsnNode> left, List<AbstractInsnNode> right) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(left);
        nodes.addAll(right);
        nodes.add(new MethodInsnNode(184, Type.getInternalName(dispatcher), "invoke", Type.getMethodDescriptor(Type.getType(returned), Type.getType(Object.class), Type.getType(Object.class)), false));
        return nodes;
    }

    @Nonnull
    private static List<AbstractInsnNode> generateBinaryMethodCallNodesWithContext(Class<?> dispatcher, Class<?> returned, List<AbstractInsnNode> left, List<AbstractInsnNode> right) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.add(new VarInsnNode(25, 1));
        nodes.addAll(left);
        nodes.addAll(right);
        nodes.add(new MethodInsnNode(184, Type.getInternalName(dispatcher), "invoke", Type.getMethodDescriptor(Type.getType(returned), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(Object.class)), false));
        return nodes;
    }
}

