/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Lambda;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class BoxLambdaTransformer
extends AbstractTransformer {
    public BoxLambdaTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxLambda boxLambda = (BoxLambda)node;
        Type type = Type.getType("L" + this.transpiler.getProperty("packageName").replace('.', '/') + "/" + this.transpiler.getProperty("classname") + "$Lambda_" + this.transpiler.incrementAndGetLambdaCounter() + ";");
        ClassNode classNode = new ClassNode();
        AsmHelper.init(classNode, true, type, Type.getType(Lambda.class), methodVisitor -> {}, new Type[0]);
        AsmHelper.addStaticFieldGetter(classNode, type, "name", "getName", Type.getType(Key.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "arguments", "getArguments", Type.getType(Argument[].class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "returnType", "getReturnType", Type.getType(String.class), "any");
        AsmHelper.addStaticFieldGetter(classNode, type, "annotations", "getAnnotations", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "documentation", "getDocumentation", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "access", "getAccess", Type.getType(Function.Access.class), null);
        Type declaringType = Type.getType("L" + this.transpiler.getProperty("packageName").replace('.', '/') + "/" + this.transpiler.getProperty("classname") + ";");
        AsmHelper.addParentGetter(classNode, declaringType, "imports", "getImports", Type.getType(List.class));
        AsmHelper.addParentGetter(classNode, declaringType, "path", "getRunnablePath", Type.getType(ResolvedFilePath.class));
        AsmHelper.addParentGetter(classNode, declaringType, "sourceType", "getSourceType", Type.getType(BoxSourceType.class));
        int componentCounter = this.transpiler.getComponentCounter();
        this.transpiler.setComponentCounter(0);
        this.transpiler.incrementfunctionBodyCounter();
        AsmHelper.methodWithContextAndClassLocator(classNode, "_invoke", Type.getType(FunctionBoxContext.class), Type.getType(Object.class), false, this.transpiler, false, () -> {
            if (boxLambda.getBody().getChildren().size() == 0) {
                return List.of(new InsnNode(1));
            }
            return boxLambda.getBody().getChildren().stream().flatMap(statement -> this.transpiler.transform((BoxNode)statement, TransformerContext.NONE, ReturnValueContext.VALUE_OR_NULL).stream()).toList();
        });
        this.transpiler.decrementfunctionBodyCounter();
        this.transpiler.setComponentCounter(componentCounter);
        AsmHelper.complete(classNode, type, methodVisitor -> {
            methodVisitor.visitFieldInsn(178, Type.getInternalName(Lambda.class), "defaultName", Type.getDescriptor(Key.class));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "name", Type.getDescriptor(Key.class));
            methodVisitor.visitLdcInsn("any");
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "returnType", Type.getDescriptor(String.class));
            AsmHelper.array(Type.getType(Argument.class), boxLambda.getArgs().stream().map(decl -> this.transpiler.transform((BoxNode)decl, TransformerContext.NONE)).toList()).forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "arguments", Type.getDescriptor(Argument[].class));
            this.transpiler.transformAnnotations(boxLambda.getAnnotations()).forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "annotations", Type.getDescriptor(IStruct.class));
            methodVisitor.visitFieldInsn(178, Type.getInternalName(Struct.class), "EMPTY", Type.getDescriptor(IStruct.class));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "documentation", Type.getDescriptor(IStruct.class));
            methodVisitor.visitFieldInsn(178, Type.getInternalName(Function.Access.class), "PUBLIC", Type.getDescriptor(Function.Access.class));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "access", Type.getDescriptor(Function.Access.class));
        });
        this.transpiler.setAuxiliary(type.getClassName(), classNode);
        return List.of(new MethodInsnNode(184, type.getInternalName(), "getInstance", Type.getMethodDescriptor(type, new Type[0]), false));
    }
}

