/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;

public class BoxMethodInvocationTransformer
extends AbstractTransformer {
    public BoxMethodInvocationTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxMethodInvocation invocation = (BoxMethodInvocation)node;
        Boolean safe = invocation.isSafe() != false || context == TransformerContext.SAFE;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        this.transpiler.getCurrentMethodContextTracker().ifPresent(tracker -> nodes.addAll(tracker.loadCurrentContext()));
        nodes.addAll(this.transpiler.transform(invocation.getObj(), context, ReturnValueContext.VALUE));
        List<AbstractInsnNode> name = null;
        name = invocation.getUsedDotAccess() != false ? this.transpiler.createKey(((BoxIdentifier)invocation.getName()).getName()) : this.transpiler.createKey(invocation.getName());
        nodes.addAll(AsmHelper.callReferencerGetAndInvoke(this.transpiler, invocation.getArguments(), name, context, (boolean)safe));
        if (returnContext.empty) {
            nodes.add(new InsnNode(87));
        }
        return nodes;
    }
}

