/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.RequestScope;
import ortus.boxlang.runtime.scopes.ServerScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxScopeTransformer
extends AbstractTransformer {
    public BoxScopeTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxScope boxScope = (BoxScope)node;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        Class scopeClass = null;
        if ("variables".equalsIgnoreCase(boxScope.getName())) {
            scopeClass = VariablesScope.class;
        } else if ("request".equalsIgnoreCase(boxScope.getName())) {
            scopeClass = RequestScope.class;
        } else if ("server".equalsIgnoreCase(boxScope.getName())) {
            scopeClass = ServerScope.class;
        } else {
            throw new ExpressionException("Scope transformation not implemented: " + boxScope.getName(), boxScope);
        }
        nodes.addAll(this.transpiler.getCurrentMethodContextTracker().get().loadCurrentContext());
        nodes.add(new FieldInsnNode(178, Type.getInternalName(scopeClass), "name", Type.getDescriptor(Key.class)));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "getScopeNearby", Type.getMethodDescriptor(Type.getType(IScope.class), Type.getType(Key.class)), true));
        return nodes;
    }
}

