/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStaticAccess;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxStaticAccessTransformer
extends AbstractTransformer {
    public BoxStaticAccessTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxStaticAccess objectAccess = (BoxStaticAccess)node;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        Boolean safe = objectAccess.isSafe() != false || context == TransformerContext.SAFE;
        this.transpiler.getCurrentMethodContextTracker().ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
        this.transpiler.getCurrentMethodContextTracker().ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
        BoxExpression boxExpression = objectAccess.getContext();
        if (boxExpression instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)boxExpression;
            nodes.add(new LdcInsnNode(fqn.getValue()));
        } else {
            boxExpression = objectAccess.getContext();
            if (boxExpression instanceof BoxIdentifier) {
                BoxIdentifier id = (BoxIdentifier)boxExpression;
                if (this.transpiler.matchesImport(id.getName()) && this.transpiler.getProperty("sourceType").toLowerCase().startsWith("box")) {
                    nodes.addAll(this.transpiler.transform(id, context, ReturnValueContext.VALUE));
                } else {
                    nodes.add(new LdcInsnNode(id.getName()));
                }
            } else {
                throw new ExpressionException("Unexpected base token in static access.", objectAccess.getContext());
            }
        }
        nodes.add(new FieldInsnNode(178, this.transpiler.getProperty("classTypeInternal"), "imports", Type.getDescriptor(List.class)));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(BoxClassSupport.class), "ensureClass", Type.getMethodDescriptor(Type.getType(DynamicObject.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(List.class)), false));
        BoxExpression boxExpression2 = objectAccess.getAccess();
        if (boxExpression2 instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)boxExpression2;
            nodes.addAll(this.transpiler.createKey(id.getName()));
        } else {
            boxExpression2 = objectAccess.getAccess();
            if (boxExpression2 instanceof BoxIntegerLiteral) {
                BoxIntegerLiteral il = (BoxIntegerLiteral)boxExpression2;
                nodes.addAll(this.transpiler.createKey(il));
            } else {
                throw new ExpressionException("Unsupported access type: " + objectAccess.getAccess().getClass().getName(), objectAccess.getAccess());
            }
        }
        nodes.add(new FieldInsnNode(178, Type.getInternalName(Boolean.class), safe != false ? "TRUE" : "FALSE", Type.getDescriptor(Boolean.class)));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Referencer.class), "get", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(Key.class), Type.getType(Boolean.class)), false));
        return nodes;
    }
}

