/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxStaticMethodInvocation;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxStaticMethodInvocationTransformer
extends AbstractTransformer {
    public BoxStaticMethodInvocationTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnValueContext) throws IllegalStateException {
        BoxStaticMethodInvocation invocation = (BoxStaticMethodInvocation)node;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        BoxExpression baseObject = invocation.getObj();
        this.transpiler.getCurrentMethodContextTracker().ifPresent(t -> nodes.addAll(t.loadCurrentContext()));
        nodes.add(new InsnNode(89));
        if (baseObject instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)baseObject;
            nodes.add(new LdcInsnNode(fqn.getValue()));
        } else if (baseObject instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)baseObject;
            nodes.addAll(this.transpiler.transform(id, context, ReturnValueContext.VALUE));
        } else {
            throw new ExpressionException("Unexpected base token in static method access.", baseObject);
        }
        nodes.add(new FieldInsnNode(178, this.transpiler.getProperty("classTypeInternal"), "imports", Type.getDescriptor(List.class)));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(BoxClassSupport.class), "ensureClass", Type.getMethodDescriptor(Type.getType(DynamicObject.class), Type.getType(IBoxContext.class), Type.getType(Object.class), Type.getType(List.class)), false));
        nodes.addAll(AsmHelper.callReferencerGetAndInvoke(this.transpiler, invocation.getArguments(), invocation.getName().toString(), context, false));
        return nodes;
    }
}

