/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;

public class BoxStringLiteralTransformer
extends AbstractTransformer {
    private static final int MAX_LITERAL_LENGTH = 30000;

    public BoxStringLiteralTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxStringLiteral literal = (BoxStringLiteral)node;
        String value = literal.getValue();
        if (value.length() < 30000) {
            return List.of(new LdcInsnNode(literal.getValue()));
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        List<String> parts2 = this.splitStringIntoParts(value);
        nodes.add(new LdcInsnNode(""));
        nodes.addAll(AsmHelper.array(Type.getType(String.class), parts2.stream().map(s -> {
            List<LdcInsnNode> x = List.of(new LdcInsnNode(s));
            return x;
        }).toList()));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(String.class), "join", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(CharSequence.class), Type.getType(CharSequence[].class)), false));
        return nodes;
    }

    private List<String> splitStringIntoParts(String str) {
        ArrayList<String> parts2 = new ArrayList<String>();
        int length = str.length();
        for (int i = 0; i < length; i += 30000) {
            int end = Math.min(length, i + 30000);
            String part = str.substring(i, end);
            parts2.add(part);
        }
        return parts2;
    }
}

