/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.operators.EqualsEquals;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.types.util.ListUtil;

public class BoxSwitchTransformer
extends AbstractTransformer {
    public BoxSwitchTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxSwitch boxSwitch = (BoxSwitch)node;
        List<AbstractInsnNode> condition = this.transpiler.transform(boxSwitch.getCondition(), TransformerContext.NONE, ReturnValueContext.VALUE);
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        AsmHelper.addDebugLabel(nodes, "BoxSwitch");
        nodes.addAll(condition);
        nodes.add(new LdcInsnNode((Object)0));
        LabelNode endLabel = new LabelNode();
        LabelNode breakTarget = new LabelNode();
        this.transpiler.getCurrentMethodContextTracker().ifPresent(t -> t.setBreak(boxSwitch, endLabel));
        boxSwitch.getCases().forEach(c -> {
            if (c.getCondition() == null) {
                return;
            }
            AsmHelper.addDebugLabel(nodes, "BoxSwitch - case start");
            LabelNode startOfCase = new LabelNode();
            LabelNode endOfCase = new LabelNode();
            LabelNode endOfAll = new LabelNode();
            nodes.add(new JumpInsnNode(154, startOfCase));
            nodes.add(new InsnNode(89));
            if (c.getDelimiter() == null) {
                nodes.addAll(this.transpiler.transform(c.getCondition(), TransformerContext.NONE, ReturnValueContext.VALUE));
                nodes.add(new MethodInsnNode(184, Type.getInternalName(EqualsEquals.class), "invoke", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class), Type.getType(Object.class)), false));
            } else {
                nodes.add(new MethodInsnNode(184, Type.getInternalName(StringCaster.class), "cast", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(Object.class)), false));
                nodes.addAll(this.transpiler.transform(c.getCondition(), TransformerContext.NONE, ReturnValueContext.VALUE));
                nodes.add(new MethodInsnNode(184, Type.getInternalName(StringCaster.class), "cast", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(Object.class)), false));
                nodes.addAll(this.transpiler.transform(c.getDelimiter(), TransformerContext.NONE, ReturnValueContext.VALUE));
                nodes.add(new MethodInsnNode(184, Type.getInternalName(ListUtil.class), "containsNoCase", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class)), false));
            }
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
            nodes.add(new JumpInsnNode(153, endOfCase));
            nodes.add(startOfCase);
            c.getBody().forEach(stmt -> nodes.addAll(this.transpiler.transform((BoxNode)stmt, TransformerContext.NONE)));
            nodes.add(new LdcInsnNode((Object)1));
            nodes.add(new JumpInsnNode(167, endOfAll));
            nodes.add(endOfCase);
            nodes.add(new LdcInsnNode((Object)0));
            nodes.add(endOfAll);
            AsmHelper.addDebugLabel(nodes, "BoxSwitch - case end");
        });
        boolean hasDefault = false;
        for (BoxSwitchCase c2 : boxSwitch.getCases()) {
            if (c2.getCondition() != null) continue;
            if (hasDefault) {
                throw new ExpressionException("Multiple default cases not supported", c2.getPosition(), c2.getSourceText());
            }
            AsmHelper.addDebugLabel(nodes, "BoxSwitch - default case");
            hasDefault = true;
            nodes.add(new InsnNode(87));
            c2.getBody().forEach(stmt -> nodes.addAll(this.transpiler.transform((BoxNode)stmt, TransformerContext.NONE)));
            nodes.add(new JumpInsnNode(167, endLabel));
        }
        nodes.add(new InsnNode(87));
        nodes.add(endLabel);
        nodes.add(new InsnNode(87));
        if (!returnContext.empty) {
            nodes.add(new InsnNode(1));
        }
        AsmHelper.addDebugLabel(nodes, "BoxSwitch - done");
        return nodes;
    }
}

