/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyDefinition;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyService;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ClassVariablesScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;
import ortus.boxlang.runtime.util.conversion.ObjectMarshaller;

public class BoxClassTransformer {
    public static final Type CLASS_TYPE = Type.getType(Class.class);
    public static final Type CLASS_ARRAY_TYPE = Type.getType(Class[].class);
    private static final String EXTENDS_ANNOTATION_MARKER = "overrideJava";

    public static ClassNode transpile(Transpiler transpiler, BoxClass boxClass) throws BoxRuntimeException {
        boolean isJavaExtends;
        SourceFile file;
        Source source = boxClass.getPosition().getSource();
        String sourceType = transpiler.getProperty("sourceType");
        String filePath = source instanceof SourceFile && (file = (SourceFile)source).getFile() != null ? file.getFile().getAbsolutePath() : "unknown";
        String boxClassName = transpiler.getProperty("boxFQN");
        transpiler.setProperty("boxClassName", boxClassName);
        String mappingName = transpiler.getProperty("mappingName");
        String mappingPath = transpiler.getProperty("mappingPath");
        String relativePath = transpiler.getProperty("relativePath");
        Type type = Type.getType("L" + transpiler.getProperty("packageName").replace('.', '/') + "/" + transpiler.getProperty("classname") + ";");
        transpiler.setProperty("classType", type.getDescriptor());
        transpiler.setProperty("classTypeInternal", type.getInternalName());
        ArrayList<Type> interfaces = new ArrayList<Type>();
        interfaces.add(Type.getType(IClassRunnable.class));
        interfaces.add(Type.getType(IReferenceable.class));
        interfaces.add(Type.getType(IType.class));
        interfaces.add(Type.getType(Serializable.class));
        List<Object> interfaceMethods = List.of();
        BoxExpression implementsValue = boxClass.getAnnotations().stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("implements")).findFirst().map(BoxAnnotation::getValue).orElse(null);
        if (implementsValue instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)implementsValue;
            String implementsStringList = str.getValue();
            Array implementsArray = ListUtil.asList(implementsStringList, ",").stream().map(String::valueOf).map(String::trim).filter(it -> it.toLowerCase().startsWith("java:")).map(it -> it.substring(5)).collect(BLCollector.toArray());
            InterfaceProxyDefinition interfaceProxyDefinition = InterfaceProxyService.generateDefinition(new ScriptingRequestBoxContext(), implementsArray);
            interfaces.addAll(interfaceProxyDefinition.interfaces().stream().map(iface -> Type.getType("L" + iface.replace('.', '/') + ";")).toList());
            interfaceMethods = interfaceProxyDefinition.methods().stream().map(method -> AsmHelper.dereferenceAndInvoke(method.getName(), Type.getType(method), type)).toList();
        }
        Type superclass = Type.getType(Object.class);
        List<Object> extendsMethods = List.of();
        BoxExpression extendsValue = boxClass.getAnnotations().stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("extends")).findFirst().map(BoxAnnotation::getValue).orElse(null);
        if (extendsValue instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)extendsValue;
            String extendsStringValue = str.getValue().trim();
            if (extendsStringValue.toLowerCase().startsWith("java:")) {
                superclass = Type.getType("L" + extendsStringValue.substring(5).replace('.', '/') + ";");
                isJavaExtends = true;
                extendsMethods = boxClass.getDescendantsOfType(BoxFunctionDeclaration.class).stream().filter(it -> it.getAnnotations().stream().anyMatch(anno -> anno.getKey().getValue().equalsIgnoreCase(EXTENDS_ANNOTATION_MARKER))).map(func -> {
                    String returnTypeString;
                    BoxReturnType boxReturnType = func.getType();
                    BoxType boxType = BoxType.Any;
                    String fqn = null;
                    if (boxReturnType != null && (boxType = boxReturnType.getType()).equals((Object)BoxType.Fqn)) {
                        fqn = boxReturnType.getFqn();
                    }
                    String string = returnTypeString = boxType.equals((Object)BoxType.Fqn) ? fqn : boxType.getSymbol();
                    if (returnTypeString.equalsIgnoreCase("Object")) {
                        returnTypeString = "java.lang.Object";
                    }
                    Type returnType = switch (returnTypeString) {
                        case "void" -> Type.VOID_TYPE;
                        case "long" -> Type.getType(Long.class);
                        default -> Type.getType("L" + returnTypeString.replace('.', '/') + ";");
                    };
                    List<BoxArgumentDeclaration> parameters = func.getArgs();
                    Type[] parameterTypes = new Type[parameters.size()];
                    for (int i = 0; i < parameters.size(); ++i) {
                        BoxArgumentDeclaration parameter = parameters.get(i);
                        parameterTypes[i] = Type.getType("L" + parameter.getType().replace('.', '/') + ";");
                    }
                    return AsmHelper.dereferenceAndInvoke(func.getName(), Type.getMethodType(returnType, parameterTypes), type);
                }).toList();
            } else {
                isJavaExtends = false;
            }
        } else {
            isJavaExtends = false;
        }
        ClassNode classNode = new ClassNode();
        AsmHelper.init(classNode, false, type, superclass, methodVisitor -> {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, Type.getInternalName(ClassVariablesScope.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(ClassVariablesScope.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IClassRunnable.class)), false);
            methodVisitor.visitFieldInsn(181, type.getInternalName(), "variablesScope", Type.getDescriptor(VariablesScope.class));
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, Type.getInternalName(ThisScope.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(ThisScope.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(181, type.getInternalName(), "thisScope", Type.getDescriptor(ThisScope.class));
            methodVisitor.visitVarInsn(25, 0);
            transpiler.createKey(boxClassName).forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(181, type.getInternalName(), "name", Type.getDescriptor(Key.class));
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitTypeInsn(187, Type.getInternalName(ArrayList.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(ArrayList.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(181, type.getInternalName(), "interfaces", Type.getDescriptor(List.class));
        }, (Type[])interfaces.toArray(Type[]::new));
        interfaceMethods.forEach(methodNode -> methodNode.accept(classNode));
        extendsMethods.forEach(methodNode -> methodNode.accept(classNode));
        classNode.visitField(26, "serialVersionUID", Type.getDescriptor(Long.TYPE), null, 1L).visitEnd();
        AsmHelper.addStaticFieldGetter(classNode, type, "imports", "getImports", Type.getType(List.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "path", "getRunnablePath", Type.getType(ResolvedFilePath.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "sourceType", "getSourceType", Type.getType(BoxSourceType.class), null);
        AsmHelper.addStaticFieldGetterWithStaticGetter(classNode, type, "annotations", "getAnnotations", "getAnnotationsStatic", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "documentation", "getDocumentation", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "properties", "getProperties", Type.getType(Map.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "getterLookup", "getGetterLookup", Type.getType(Map.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "setterLookup", "getSetterLookup", Type.getType(Map.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "isJavaExtends", "isJavaExtends", Type.BOOLEAN_TYPE, isJavaExtends ? 1 : 0);
        AsmHelper.addStaticFieldGetterWithStaticGetter(classNode, type, "staticScope", "getStaticScope", "getStaticScopeStatic", Type.getType(StaticScope.class), null);
        classNode.visitField(25, "keys", Type.getDescriptor(Key[].class), null, null).visitEnd();
        classNode.visitField(9, "staticInitialized", Type.getDescriptor(Boolean.TYPE), null, 0).visitEnd();
        AsmHelper.addPrviateStaticFieldGetter(classNode, type, "compileTimeMethodNames", "getCompileTimeMethodNames", Type.getType(Set.class), null);
        AsmHelper.addPrviateStaticFieldGetter(classNode, type, "abstractMethods", "getAbstractMethods", Type.getType(Map.class), null);
        MethodVisitor getAllAbstractMethodsMethodVisitor = classNode.visitMethod(1, "getAllAbstractMethods", Type.getMethodDescriptor(Type.getType(Map.class), new Type[0]), null, null);
        getAllAbstractMethodsMethodVisitor.visitCode();
        getAllAbstractMethodsMethodVisitor.visitVarInsn(25, 0);
        getAllAbstractMethodsMethodVisitor.visitFieldInsn(178, type.getInternalName(), "abstractMethods", Type.getType(Map.class).getDescriptor());
        getAllAbstractMethodsMethodVisitor.visitInsn(Type.getType(Map.class).getOpcode(172));
        getAllAbstractMethodsMethodVisitor.visitMaxs(0, 0);
        getAllAbstractMethodsMethodVisitor.visitEnd();
        MethodVisitor writeReplaceMethodVisitor = classNode.visitMethod(2, "writeReplace", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), null, new String[]{Type.getInternalName(ObjectStreamException.class)});
        writeReplaceMethodVisitor.visitCode();
        writeReplaceMethodVisitor.visitVarInsn(25, 0);
        writeReplaceMethodVisitor.visitMethodInsn(184, Type.getInternalName(ObjectMarshaller.class), "serializeClass", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(IClassRunnable.class)), false);
        writeReplaceMethodVisitor.visitInsn(Type.getType(Map.class).getOpcode(172));
        writeReplaceMethodVisitor.visitMaxs(0, 0);
        writeReplaceMethodVisitor.visitEnd();
        BoxClassTransformer.defineLookupPrivateMethod(transpiler, classNode, type);
        BoxClassTransformer.defineLookupPrivateField(transpiler, classNode, type);
        AsmHelper.addFieldGetter(classNode, type, "variablesScope", "getVariablesScope", Type.getType(VariablesScope.class), null);
        AsmHelper.addFieldGetter(classNode, type, "thisScope", "getThisScope", Type.getType(ThisScope.class), null);
        AsmHelper.addFieldGetter(classNode, type, "name", "getName", Type.getType(Key.class), null);
        AsmHelper.addFieldGetter(classNode, type, "interfaces", "getInterfaces", Type.getType(List.class), null);
        AsmHelper.addFieldGetterAndSetter(classNode, type, "_super", "getSuper", "_setSuper", Type.getType(IClassRunnable.class), null, methodVisitor -> {});
        AsmHelper.addFieldGetterAndSetter(classNode, type, "child", "getChild", "setChild", Type.getType(IClassRunnable.class), null, methodVisitor -> {});
        AsmHelper.addFieldGetterAndSetter(classNode, type, "canOutput", "getCanOutput", "setCanOutput", Type.getType(Boolean.class), null, methodVisitor -> {});
        AsmHelper.addFieldGetterAndSetter(classNode, type, "$bx", "_getbx", "_setbx", Type.getType(BoxMeta.class), null, methodVisitor -> {});
        AsmHelper.addFieldGetterAndSetter(classNode, type, "canInvokeImplicitAccessor", "getCanInvokeImplicitAccessor", "setCanInvokeImplicitAccessor", Type.getType(Boolean.class), null, methodVisitor -> {});
        AsmHelper.boxClassSupport(classNode, "pseudoConstructor", Type.VOID_TYPE, Type.getType(IBoxContext.class));
        AsmHelper.boxClassSupport(classNode, "canOutput", Type.getType(Boolean.class), new Type[0]);
        AsmHelper.boxClassSupport(classNode, "getBoxMeta", Type.getType(BoxMeta.class), new Type[0]);
        AsmHelper.boxClassSupport(classNode, "getMetaData", Type.getType(IStruct.class), new Type[0]);
        AsmHelper.boxClassSupport(classNode, "asString", Type.getType(String.class), new Type[0]);
        AsmHelper.boxClassSupport(classNode, "canInvokeImplicitAccessor", Type.getType(Boolean.class), Type.getType(IBoxContext.class));
        AsmHelper.boxClassSupport(classNode, "setSuper", Type.VOID_TYPE, Type.getType(IClassRunnable.class));
        AsmHelper.boxClassSupport(classNode, "getBottomClass", Type.getType(IClassRunnable.class), new Type[0]);
        AsmHelper.boxClassSupport(classNode, "assign", Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Object.class));
        AsmHelper.boxClassSupport(classNode, "dereference", Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Boolean.class));
        AsmHelper.boxClassSupport(classNode, "dereferenceAndInvoke", Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Object[].class), Type.getType(Boolean.class));
        AsmHelper.boxClassSupport(classNode, "dereferenceAndInvoke", Type.getType(Object.class), Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Map.class), Type.getType(Boolean.class));
        AsmHelper.boxClassSupport(classNode, "registerInterface", Type.VOID_TYPE, Type.getType(BoxInterface.class));
        ArrayList<List<AbstractInsnNode>> imports = new ArrayList<List<AbstractInsnNode>>();
        for (BoxImport statement : boxClass.getImports()) {
            imports.add(transpiler.transform(statement, TransformerContext.NONE, ReturnValueContext.EMPTY));
        }
        List<AbstractInsnNode> importNodes = AsmHelper.array(Type.getType(ImportDefinition.class), Stream.concat(imports.stream(), transpiler.getImports().stream().map(raw -> {
            ArrayList<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
            nodes.addAll((Collection<MethodInsnNode>)raw);
            nodes.add(new MethodInsnNode(184, Type.getInternalName(ImportDefinition.class), "parse", Type.getMethodDescriptor(Type.getType(ImportDefinition.class), Type.getType(String.class)), false));
            return nodes;
        })).filter(l -> l.size() > 0).toList());
        AsmHelper.methodWithContextAndClassLocator(classNode, "_pseudoConstructor", Type.getType(IBoxContext.class), Type.VOID_TYPE, false, transpiler, false, () -> {
            List psuedoBody = boxClass.getBody().stream().sorted((a, b) -> {
                if (a instanceof BoxFunctionDeclaration && !(b instanceof BoxFunctionDeclaration)) {
                    return -1;
                }
                if (b instanceof BoxFunctionDeclaration && !(a instanceof BoxFunctionDeclaration)) {
                    return 1;
                }
                return 0;
            }).flatMap(statement -> transpiler.transform((BoxNode)statement, TransformerContext.NONE, ReturnValueContext.EMPTY).stream()).collect(Collectors.toList());
            psuedoBody.add(new VarInsnNode(25, 0));
            psuedoBody.add(new VarInsnNode(25, 1));
            psuedoBody.add(new MethodInsnNode(184, Type.getInternalName(BoxClassSupport.class), "defaultProperties", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IClassRunnable.class), Type.getType(IBoxContext.class)), false));
            return psuedoBody;
        });
        AsmHelper.methodWithContextAndClassLocator(classNode, "staticInitializer", Type.getType(IBoxContext.class), Type.VOID_TYPE, true, transpiler, false, () -> {
            List staticNodes = transpiler.getBoxStaticInitializers().stream().map(staticInitializer -> {
                if (staticInitializer == null || staticInitializer.getBody().size() == 0) {
                    return new ArrayList();
                }
                return staticInitializer.getBody().stream().map(statement -> transpiler.transform((BoxNode)statement, TransformerContext.NONE)).flatMap(nodes -> nodes.stream()).collect(Collectors.toList());
            }).flatMap(s -> s.stream()).collect(Collectors.toList());
            boxClass.getDescendantsOfType(BoxFunctionDeclaration.class, expr -> {
                BoxFunctionDeclaration func = expr;
                return func.getModifiers().contains((Object)BoxMethodDeclarationModifier.STATIC);
            }).forEach(func -> staticNodes.addAll(transpiler.transform((BoxNode)func, TransformerContext.NONE)));
            return staticNodes;
        });
        AsmHelper.complete(classNode, type, methodVisitor -> {
            AsmHelper.resolvedFilePath(methodVisitor, mappingName, mappingPath, relativePath, filePath);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "path", Type.getDescriptor(ResolvedFilePath.class));
            methodVisitor.visitFieldInsn(178, Type.getInternalName(BoxSourceType.class), sourceType, Type.getDescriptor(BoxSourceType.class));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "sourceType", Type.getDescriptor(BoxSourceType.class));
            List<AbstractInsnNode> annotations = transpiler.transformAnnotations(boxClass.getAnnotations());
            List<AbstractInsnNode> documenation = transpiler.transformDocumentation(boxClass.getDocumentation());
            List<List<AbstractInsnNode>> properties = transpiler.transformProperties(type, boxClass.getProperties(), sourceType);
            methodVisitor.visitLdcInsn(transpiler.getKeys().size());
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Key.class));
            int index = 0;
            for (BoxExpression expression : transpiler.getKeys().values()) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn(index++);
                transpiler.transform(expression, TransformerContext.NONE, ReturnValueContext.EMPTY).forEach(methodInsnNode -> methodInsnNode.accept((MethodVisitor)methodVisitor));
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Key.class), "of", Type.getMethodDescriptor(Type.getType(Key.class), Type.getType(Object.class)), false);
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "keys", Type.getDescriptor(Key[].class));
            methodVisitor.visitLdcInsn(0);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "staticInitialized", Type.getDescriptor(Boolean.TYPE));
            methodVisitor.visitTypeInsn(187, Type.getInternalName(StaticScope.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(StaticScope.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "staticScope", Type.getDescriptor(StaticScope.class));
            methodVisitor.visitLdcInsn(isJavaExtends ? 1 : 0);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "isJavaExtends", Type.getDescriptor(Boolean.TYPE));
            methodVisitor.visitLdcInsn(1L);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "serialVersionUID", Type.getDescriptor(Long.TYPE));
            importNodes.forEach(node -> node.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(List.class), "of", Type.getMethodDescriptor(Type.getType(List.class), Type.getType(Object[].class)), true);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "imports", Type.getDescriptor(List.class));
            annotations.forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "annotations", Type.getDescriptor(IStruct.class));
            documenation.forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "documentation", Type.getDescriptor(IStruct.class));
            properties.get(0).forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "properties", Type.getDescriptor(Map.class));
            properties.get(1).forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "getterLookup", Type.getDescriptor(Map.class));
            properties.get(2).forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "setterLookup", Type.getDescriptor(Map.class));
            BoxClassTransformer.generateSetOfCompileTimeMethodNames(transpiler, boxClass).forEach(node -> node.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "compileTimeMethodNames", Type.getDescriptor(Set.class));
            AsmHelper.generateMapOfAbstractMethodNames(transpiler, boxClass).forEach(node -> node.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "abstractMethods", Type.getDescriptor(Map.class));
        });
        return classNode;
    }

    private static List<AbstractInsnNode> generateSetOfCompileTimeMethodNames(Transpiler transpiler, BoxClass boxClass) {
        List<List<AbstractInsnNode>> methodKeyLists = boxClass.getDescendantsOfType(BoxFunctionDeclaration.class).stream().map(BoxFunctionDeclaration::getName).map(transpiler::createKey).collect(Collectors.toList());
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(AsmHelper.array(Type.getType(Key.class), methodKeyLists));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(Set.class), "of", Type.getMethodDescriptor(Type.getType(Set.class), Type.getType(Object[].class)), true));
        return nodes;
    }

    private static void defineLookupPrivateMethod(Transpiler transpiler, ClassNode classNode, Type thisType) {
        Type returnType = Type.getType(MethodHandle.class);
        MethodVisitor methodVisitor = classNode.visitMethod(1, "lookupPrivateMethod", Type.getMethodDescriptor(returnType, Type.getType(Method.class)), null, null);
        methodVisitor.visitCode();
        Label tryStart = new Label();
        methodVisitor.visitLabel(tryStart);
        methodVisitor.visitMethodInsn(184, Type.getType(MethodHandles.class).getInternalName(), "lookup", Type.getMethodDescriptor(Type.getType(MethodHandles.Lookup.class), new Type[0]), false);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, Type.getType(Member.class).getInternalName(), "getDeclaringClass", Type.getMethodDescriptor(CLASS_TYPE, new Type[0]), true);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, Type.getType(Member.class).getInternalName(), "getName", Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), true);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, Type.getType(Method.class).getInternalName(), "getReturnType", Type.getMethodDescriptor(CLASS_TYPE, new Type[0]), false);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, Type.getType(Method.class).getInternalName(), "getParameterTypes", Type.getMethodDescriptor(CLASS_ARRAY_TYPE, new Type[0]), false);
        methodVisitor.visitMethodInsn(184, Type.getType(MethodType.class).getInternalName(), "methodType", Type.getMethodDescriptor(Type.getType(MethodType.class), CLASS_TYPE, CLASS_ARRAY_TYPE), false);
        methodVisitor.visitLdcInsn(thisType);
        methodVisitor.visitMethodInsn(182, Type.getType(MethodHandles.Lookup.class).getInternalName(), "findSpecial", Type.getMethodDescriptor(Type.getType(MethodHandle.class), CLASS_TYPE, Type.getType(String.class), Type.getType(MethodType.class), CLASS_TYPE), false);
        methodVisitor.visitInsn(176);
        Label tryEnd = new Label();
        Label handler = new Label();
        methodVisitor.visitLabel(tryEnd);
        methodVisitor.visitLabel(handler);
        methodVisitor.visitVarInsn(58, 2);
        methodVisitor.visitTryCatchBlock(tryStart, tryEnd, handler, Type.getInternalName(NoSuchMethodException.class));
        methodVisitor.visitTryCatchBlock(tryStart, tryEnd, handler, Type.getInternalName(IllegalAccessException.class));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(BoxRuntimeException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Error getting Java super class method ");
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, Type.getType(Member.class).getInternalName(), "getName", Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), true);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(String.class), "concat", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(String.class)), false);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(BoxRuntimeException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.getType(Throwable.class)), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void defineLookupPrivateField(Transpiler transpiler, ClassNode classNode, Type thisType) {
        Type returnType = Type.getType(MethodHandle.class);
        MethodVisitor methodVisitor = classNode.visitMethod(1, "lookupPrivateField", Type.getMethodDescriptor(returnType, Type.getType(Field.class)), null, null);
        methodVisitor.visitCode();
        Label tryStart = new Label();
        methodVisitor.visitLabel(tryStart);
        methodVisitor.visitMethodInsn(184, Type.getType(MethodHandles.class).getInternalName(), "lookup", Type.getMethodDescriptor(Type.getType(MethodHandles.Lookup.class), new Type[0]), false);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, Type.getType(MethodHandles.Lookup.class).getInternalName(), "unreflectGetter", Type.getMethodDescriptor(Type.getType(MethodHandle.class), Type.getType(Field.class)), false);
        methodVisitor.visitInsn(176);
        Label tryEnd = new Label();
        Label handler = new Label();
        methodVisitor.visitLabel(tryEnd);
        methodVisitor.visitLabel(handler);
        methodVisitor.visitVarInsn(58, 2);
        methodVisitor.visitTryCatchBlock(tryStart, tryEnd, handler, Type.getInternalName(NoSuchMethodException.class));
        methodVisitor.visitTryCatchBlock(tryStart, tryEnd, handler, Type.getInternalName(IllegalAccessException.class));
        methodVisitor.visitTypeInsn(187, Type.getInternalName(BoxRuntimeException.class));
        methodVisitor.visitInsn(89);
        methodVisitor.visitLdcInsn("Error getting Java super class field ");
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(185, Type.getType(Field.class).getInternalName(), "getName", Type.getMethodDescriptor(Type.getType(String.class), new Type[0]), true);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(String.class), "concat", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(String.class)), false);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(BoxRuntimeException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.getType(Throwable.class)), false);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }
}

