/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.runtime.components.Component;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;

public class BoxComponentTransformer
extends AbstractTransformer {
    public BoxComponentTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxComponent boxComponent = (BoxComponent)node;
        Optional<MethodContextTracker> trackerOption = this.transpiler.getCurrentMethodContextTracker();
        if (trackerOption.isEmpty()) {
            throw new IllegalStateException();
        }
        this.transpiler.incrementComponentCounter();
        MethodContextTracker tracker = trackerOption.get();
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(tracker.loadCurrentContext());
        String componentName = boxComponent.getName();
        List<BoxAnnotation> attributes = boxComponent.getAttributes();
        if (componentName.startsWith("_")) {
            attributes.add(new BoxAnnotation(new BoxFQN("name", null, componentName), new BoxStringLiteral(componentName.substring(1), null, componentName), null, null));
            componentName = "module";
        }
        nodes.addAll(this.transpiler.createKey(componentName));
        nodes.addAll(this.transpiler.transformAnnotations(attributes, true, false));
        nodes.addAll(this.generateBodyNodes(boxComponent.getBody()));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "invokeComponent", Type.getMethodDescriptor(Type.getType(Component.BodyResult.class), Type.getType(Key.class), Type.getType(IStruct.class), Type.getType(Component.ComponentBody.class)), true));
        if (boxComponent.getBody() == null || boxComponent.getBody().size() == 0) {
            nodes.add(new InsnNode(87));
            this.transpiler.decrementComponentCounter();
            return nodes;
        }
        if (this.transpiler.canReturn()) {
            LabelNode ifLabel = new LabelNode();
            nodes.add(new InsnNode(89));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Component.BodyResult.class), "isEarlyExit", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
            nodes.add(new JumpInsnNode(153, ifLabel));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Component.BodyResult.class), "returnValue", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), false));
            nodes.add(new InsnNode(176));
            nodes.add(ifLabel);
        }
        nodes.add(new InsnNode(87));
        this.transpiler.decrementComponentCounter();
        return nodes;
    }

    private List<AbstractInsnNode> generateBodyNodes(List<BoxStatement> body) {
        if (body == null || body.size() == 0) {
            return List.of(new InsnNode(1));
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        Type bodyType = this.defineBodyLambdaClass(body);
        nodes.add(new TypeInsnNode(187, bodyType.getInternalName()));
        nodes.add(new InsnNode(89));
        nodes.add(new MethodInsnNode(183, bodyType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false));
        return nodes;
    }

    private Type defineBodyLambdaClass(List<BoxStatement> body) {
        Type type = Type.getType("L" + this.transpiler.getProperty("packageName").replace('.', '/') + "/" + this.transpiler.getProperty("classname") + "$ComponentBodyLambda_" + this.transpiler.incrementAndGetLambdaCounter() + ";");
        ClassNode classNode = new ClassNode();
        AsmHelper.init(classNode, false, type, Type.getType(Object.class), methodVisitor -> {}, Type.getType(Component.ComponentBody.class));
        AsmHelper.methodWithContextAndClassLocator(classNode, "process", Type.getType(IBoxContext.class), Type.getType(Component.BodyResult.class), false, this.transpiler, false, () -> {
            ArrayList<Object> nodes = new ArrayList<Object>();
            nodes.addAll(body.stream().flatMap(statement -> this.transpiler.transform((BoxNode)statement, TransformerContext.NONE).stream()).toList());
            nodes.add(new FieldInsnNode(178, Type.getInternalName(Component.class), "DEFAULT_RETURN", Type.getDescriptor(Component.BodyResult.class)));
            return nodes;
        });
        AsmHelper.complete(classNode, type, methodVisitor -> {});
        this.transpiler.setAuxiliary(type.getClassName(), classNode);
        return type;
    }
}

