/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.AsmTranspiler;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.expression.BoxAssignmentTransformer;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.runtime.dynamic.casters.CollectionCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.Struct;

public class BoxForInTransformer
extends AbstractTransformer {
    public BoxForInTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnValueContext) {
        BoxForIn forIn = (BoxForIn)node;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        AsmHelper.addDebugLabel(nodes, "BoxForIn");
        Optional<MethodContextTracker> trackerOption = this.transpiler.getCurrentMethodContextTracker();
        if (trackerOption.isEmpty()) {
            throw new IllegalStateException();
        }
        MethodContextTracker tracker = trackerOption.get();
        LabelNode loopStart = new LabelNode();
        LabelNode loopEnd = new LabelNode();
        LabelNode breakTarget = new LabelNode();
        tracker.setContinue(forIn, loopStart);
        tracker.setBreak(forIn, breakTarget);
        if (forIn.getLabel() != null) {
            tracker.setStringLabel(forIn.getLabel(), forIn);
        }
        nodes.addAll(this.transpiler.transform(forIn.getExpression(), context, ReturnValueContext.VALUE_OR_NULL));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(DynamicObject.class), "unWrap", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class)), false));
        MethodContextTracker.VarStore collectionVar = tracker.storeNewVariable(58);
        nodes.addAll(collectionVar.nodes());
        nodes.add(new VarInsnNode(25, collectionVar.index()));
        nodes.add(new TypeInsnNode(193, Type.getType(Query.class).getInternalName()));
        MethodContextTracker.VarStore isQueryVar = tracker.storeNewVariable(54);
        nodes.addAll(isQueryVar.nodes());
        nodes.add(new VarInsnNode(25, collectionVar.index()));
        nodes.add(new TypeInsnNode(193, Type.getType(Struct.class).getInternalName()));
        MethodContextTracker.VarStore isStructVar = tracker.storeNewVariable(54);
        nodes.addAll(isStructVar.nodes());
        nodes.add(new VarInsnNode(25, collectionVar.index()));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(CollectionCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Collection.class), Type.getType(Object.class)), false));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(Iterable.class), "iterator", Type.getMethodDescriptor(Type.getType(Iterator.class), new Type[0]), true));
        MethodContextTracker.VarStore iteratorVar = tracker.storeNewVariable(58);
        nodes.addAll(iteratorVar.nodes());
        if (returnValueContext == ReturnValueContext.VALUE_OR_NULL) {
            nodes.add(new InsnNode(1));
            nodes.add(new InsnNode(1));
        }
        nodes.add(loopStart);
        if (returnValueContext == ReturnValueContext.VALUE_OR_NULL) {
            nodes.add(new InsnNode(95));
            nodes.add(new InsnNode(87));
        }
        nodes.add(new VarInsnNode(25, iteratorVar.index()));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(Iterator.class), "hasNext", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), true));
        nodes.add(new JumpInsnNode(153, loopEnd));
        nodes.addAll(this.assignVar(forIn, iteratorVar.index(), context));
        nodes.add(new InsnNode(87));
        nodes.addAll(this.transpiler.transform(forIn.getBody(), context, returnValueContext));
        nodes.add(new JumpInsnNode(167, loopStart));
        nodes.add(breakTarget);
        if (returnValueContext == ReturnValueContext.VALUE_OR_NULL) {
            nodes.add(new InsnNode(95));
            nodes.add(new InsnNode(87));
        }
        nodes.add(loopEnd);
        return nodes;
    }

    private List<AbstractInsnNode> assignVar(BoxForIn forIn, int iteratorIndex, TransformerContext context) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.add(new VarInsnNode(25, iteratorIndex));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(Iterator.class), "next", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]), true));
        ArrayList<BoxAssignmentModifier> modifiers = new ArrayList<BoxAssignmentModifier>();
        if (forIn.getHasVar().booleanValue()) {
            modifiers.add(BoxAssignmentModifier.VAR);
        }
        return new BoxAssignmentTransformer((AsmTranspiler)this.transpiler).transformEquals(forIn.getVariable(), nodes, BoxAssignmentOperator.Equal, modifiers);
    }
}

