/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;

public class BoxForIndexTransformer
extends AbstractTransformer {
    public BoxForIndexTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnValueContext) {
        BoxForIndex forIn = (BoxForIndex)node;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        AsmHelper.addDebugLabel(nodes, "BoxForIndex");
        Optional<MethodContextTracker> trackerOption = this.transpiler.getCurrentMethodContextTracker();
        if (trackerOption.isEmpty()) {
            throw new IllegalStateException();
        }
        MethodContextTracker tracker = trackerOption.get();
        LabelNode breakTarget = new LabelNode();
        LabelNode firstLoop = new LabelNode();
        LabelNode loopStart = new LabelNode();
        LabelNode loopEnd = new LabelNode();
        tracker.setContinue(forIn, loopStart);
        tracker.setBreak(forIn, breakTarget);
        if (forIn.getLabel() != null) {
            tracker.setStringLabel(forIn.getLabel(), forIn);
        }
        if (forIn.getInitializer() != null) {
            AsmHelper.addDebugLabel(nodes, "BoxForIndex - initializer");
            nodes.addAll(this.transpiler.transform(forIn.getInitializer(), context, ReturnValueContext.EMPTY));
        }
        nodes.add(new InsnNode(1));
        nodes.add(new InsnNode(1));
        nodes.add(new JumpInsnNode(167, firstLoop));
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - loopStart");
        nodes.add(loopStart);
        if (forIn.getStep() != null) {
            AsmHelper.addDebugLabel(nodes, "BoxForIndex - step");
            nodes.addAll(this.transpiler.transform(forIn.getStep(), context, ReturnValueContext.EMPTY));
        }
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - firstLoop");
        nodes.add(firstLoop);
        nodes.add(new InsnNode(95));
        nodes.add(new InsnNode(87));
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - condition");
        if (forIn.getCondition() != null) {
            nodes.addAll(this.transpiler.transform(forIn.getCondition(), context, ReturnValueContext.VALUE));
            nodes.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.getType(Boolean.TYPE), new Type[0]), false));
        } else {
            nodes.add(new LdcInsnNode((Object)1));
        }
        nodes.add(new JumpInsnNode(153, loopEnd));
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - body");
        nodes.addAll(this.transpiler.transform(forIn.getBody(), context, ReturnValueContext.VALUE_OR_NULL));
        nodes.add(new JumpInsnNode(167, loopStart));
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - breakTarget");
        nodes.add(breakTarget);
        nodes.add(new InsnNode(95));
        nodes.add(new InsnNode(87));
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - loopEnd");
        nodes.add(loopEnd);
        if (returnValueContext.empty) {
            nodes.add(new InsnNode(87));
        }
        tracker.setCurrentBreak(null, null);
        tracker.setCurrentContinue(null, null);
        AsmHelper.addDebugLabel(nodes, "BoxForIndex - done");
        return nodes;
    }
}

