/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.AsmTranspiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class BoxFunctionDeclarationTransformer
extends AbstractTransformer {
    public BoxFunctionDeclarationTransformer(AsmTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxFunctionDeclaration function = (BoxFunctionDeclaration)node;
        TransformerContext safe = function.getName().equalsIgnoreCase("isnull") ? TransformerContext.SAFE : context;
        Type type = Type.getType("L" + this.transpiler.getProperty("packageName").replace('.', '/') + "/" + this.transpiler.getProperty("classname") + "$Func_" + function.getName() + ";");
        BoxReturnType boxReturnType = function.getType();
        BoxType returnType = BoxType.Any;
        String fqn = null;
        if (boxReturnType != null && (returnType = boxReturnType.getType()).equals((Object)BoxType.Fqn)) {
            fqn = boxReturnType.getFqn();
        }
        String returnTypeName = returnType.equals((Object)BoxType.Fqn) ? fqn : returnType.name();
        BoxAccessModifier access = function.getAccessModifier() == null ? BoxAccessModifier.Public : function.getAccessModifier();
        ClassNode classNode = new ClassNode();
        AsmHelper.init(classNode, true, type, Type.getType(UDF.class), methodVisitor -> {}, new Type[0]);
        this.transpiler.setAuxiliary(type.getClassName(), classNode);
        AsmHelper.addStaticFieldGetter(classNode, type, "modifiers", "getModifiers", Type.getType(List.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "name", "getName", Type.getType(Key.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "arguments", "getArguments", Type.getType(Argument[].class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "returnType", "getReturnType", Type.getType(String.class), returnTypeName);
        AsmHelper.addStaticFieldGetter(classNode, type, "access", "getAccess", Type.getType(Function.Access.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "annotations", "getAnnotations", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "documentation", "getDocumentation", Type.getType(IStruct.class), null);
        Type declaringType = Type.getType("L" + this.transpiler.getProperty("packageName").replace('.', '/') + "/" + this.transpiler.getProperty("classname") + ";");
        AsmHelper.addParentGetter(classNode, declaringType, "imports", "getImports", Type.getType(List.class));
        AsmHelper.addParentGetter(classNode, declaringType, "path", "getRunnablePath", Type.getType(ResolvedFilePath.class));
        AsmHelper.addParentGetter(classNode, declaringType, "sourceType", "getSourceType", Type.getType(BoxSourceType.class));
        this.transpiler.incrementfunctionBodyCounter();
        AsmHelper.methodWithContextAndClassLocator(classNode, "_invoke", Type.getType(FunctionBoxContext.class), Type.getType(Object.class), false, this.transpiler, true, () -> {
            if (function.getBody() == null) {
                return new ArrayList();
            }
            return function.getBody().stream().flatMap(statement -> this.transpiler.transform((BoxNode)statement, safe, ReturnValueContext.EMPTY).stream()).toList();
        });
        this.transpiler.decrementfunctionBodyCounter();
        AsmHelper.complete(classNode, type, methodVisitor -> {
            this.transpiler.createKey(function.getName()).forEach(methodInsnNode -> methodInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "name", Type.getDescriptor(Key.class));
            methodVisitor.visitLdcInsn(returnTypeName);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "returnType", Type.getDescriptor(String.class));
            methodVisitor.visitFieldInsn(178, Type.getInternalName(Function.Access.class), access.name().toUpperCase(), Type.getDescriptor(Function.Access.class));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "access", Type.getDescriptor(Function.Access.class));
            AsmHelper.array(Type.getType(Argument.class), function.getArgs(), (arg, i) -> this.transpiler.transform((BoxNode)arg, safe)).forEach(methodInsnNode -> methodInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "arguments", Type.getDescriptor(Argument[].class));
            this.transpiler.transformAnnotations(function.getAnnotations()).forEach(methodInsnNode -> methodInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "annotations", Type.getDescriptor(IStruct.class));
            this.transpiler.transformDocumentation(function.getDocumentation()).forEach(methodInsnNode -> methodInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "documentation", Type.getDescriptor(IStruct.class));
            AsmHelper.array(Type.getType(BoxMethodDeclarationModifier.class), function.getModifiers(), (bmdm, i) -> List.of(new FieldInsnNode(178, Type.getInternalName(BoxMethodDeclarationModifier.class), bmdm.toString().toUpperCase(), Type.getDescriptor(BoxMethodDeclarationModifier.class)))).stream().forEach(modifierNode -> modifierNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(List.class), "of", Type.getMethodDescriptor(Type.getType(List.class), Type.getType(Object[].class)), true);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "modifiers", Type.getDescriptor(List.class));
        });
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(this.transpiler.getCurrentMethodContextTracker().get().loadCurrentContext());
        nodes.add(new MethodInsnNode(184, type.getInternalName(), "getInstance", Type.getMethodDescriptor(type, new Type[0]), false));
        nodes.add(new MethodInsnNode(185, Type.getInternalName(IBoxContext.class), "registerUDF", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(UDF.class)), true));
        if (returnContext.nullable) {
            nodes.add(new InsnNode(1));
        }
        return nodes;
    }
}

