/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;

public class BoxIfElseTransformer
extends AbstractTransformer {
    public BoxIfElseTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) {
        BoxIfElse ifElse = (BoxIfElse)node;
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        AsmHelper.addDebugLabel(nodes, "BoxIf");
        nodes.addAll(this.transpiler.transform(ifElse.getCondition(), TransformerContext.NONE, ReturnValueContext.VALUE));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
        nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
        LabelNode ifLabel = new LabelNode();
        nodes.add(new JumpInsnNode(153, ifLabel));
        nodes.addAll(this.transpiler.transform(ifElse.getThenBody(), TransformerContext.NONE, returnContext));
        if (ifElse.getElseBody() == null) {
            LabelNode elseLabel = new LabelNode();
            nodes.add(new JumpInsnNode(167, elseLabel));
            nodes.add(ifLabel);
            if (returnContext == ReturnValueContext.VALUE_OR_NULL) {
                nodes.add(new InsnNode(1));
            }
            nodes.add(elseLabel);
        } else if (ifElse.getElseBody() != null) {
            LabelNode elseLabel = new LabelNode();
            nodes.add(new JumpInsnNode(167, elseLabel));
            nodes.add(ifLabel);
            nodes.addAll(this.transpiler.transform(ifElse.getElseBody(), TransformerContext.NONE, returnContext));
            nodes.add(elseLabel);
        } else {
            nodes.add(ifLabel);
        }
        return nodes;
    }
}

