/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStaticInitializer;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.InterfaceBoxContext;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IBoxRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class BoxInterfaceTransformer {
    public static ClassNode transpile(Transpiler transpiler, ortus.boxlang.compiler.ast.BoxInterface boxInterface) throws BoxRuntimeException {
        SourceFile file;
        SourceFile file2;
        Source source = boxInterface.getPosition().getSource();
        String packageName = transpiler.getProperty("packageName");
        String boxPackageName = transpiler.getProperty("boxFQN");
        transpiler.setProperty("boxClassName", boxPackageName);
        String classname = transpiler.getProperty("classname");
        String mappingName = transpiler.getProperty("mappingName");
        String mappingPath = transpiler.getProperty("mappingPath");
        String relativePath = transpiler.getProperty("relativePath");
        String fileName = source instanceof SourceFile && (file2 = (SourceFile)source).getFile() != null ? file2.getFile().getName() : "unknown";
        String filePath = source instanceof SourceFile && (file = (SourceFile)source).getFile() != null ? file.getFile().getAbsolutePath() : "unknown";
        String boxInterfacename = transpiler.getProperty("boxFQN");
        String sourceType = transpiler.getProperty("sourceType");
        Type type = Type.getType("L" + packageName.replace('.', '/') + "/" + classname + ";");
        transpiler.setProperty("classType", type.getDescriptor());
        transpiler.setProperty("classTypeInternal", type.getInternalName());
        ClassNode classNode = new ClassNode();
        AsmHelper.init(classNode, false, type, Type.getType(BoxInterface.class), methodVisitor -> {}, new Type[0]);
        AsmHelper.addLazySingleton(classNode, type, methodVisitor -> {
            methodVisitor.visitTypeInsn(187, type.getInternalName());
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, type.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "instance", type.getDescriptor());
            methodVisitor.visitTypeInsn(187, Type.getInternalName(StaticScope.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
            methodVisitor.visitMethodInsn(183, Type.getInternalName(StaticScope.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(BoxInterface.class)), false);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "staticScope", Type.getDescriptor(StaticScope.class));
            methodVisitor.visitTypeInsn(187, Type.getInternalName(InterfaceBoxContext.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
            methodVisitor.visitMethodInsn(183, Type.getInternalName(InterfaceBoxContext.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class), Type.getType(BoxInterface.class)), false);
            methodVisitor.visitVarInsn(58, 1);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
            methodVisitor.visitMethodInsn(182, Type.getInternalName(InterfaceBoxContext.class), "pushTemplate", Type.getMethodDescriptor(Type.getType(IBoxContext.class), Type.getType(IBoxRunnable.class)), false);
            methodVisitor.visitInsn(87);
            methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(BoxInterface.class), "resolveSupers", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class)), false);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(184, type.getInternalName(), "staticInitializer", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class)), false);
            methodVisitor.visitFieldInsn(178, type.getInternalName(), "instance", type.getDescriptor());
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(182, type.getInternalName(), "pseudoConstructor", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class)), false);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(182, Type.getInternalName(InterfaceBoxContext.class), "popTemplate", Type.getMethodDescriptor(Type.getType(ResolvedFilePath.class), new Type[0]), false);
            methodVisitor.visitInsn(87);
        }, Type.getType(IBoxContext.class));
        AsmHelper.addStaticFieldGetter(classNode, type, "imports", "getImports", Type.getType(List.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "path", "getRunnablePath", Type.getType(ResolvedFilePath.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "sourceType", "getSourceType", Type.getType(BoxSourceType.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "annotations", "getAnnotations", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "documentation", "getDocumentation", Type.getType(IStruct.class), null);
        AsmHelper.addStaticFieldGetterWithStaticGetter(classNode, type, "staticScope", "getStaticScope", "getStaticScopeStatic", Type.getType(StaticScope.class), null, false);
        AsmHelper.addStaticFieldGetter(classNode, type, "name", "getName", Type.getType(Key.class), null);
        AsmHelper.addStaticFieldGetter(classNode, type, "_supers", "getSupers", Type.getType(List.class), null);
        MethodVisitor addSuper = classNode.visitMethod(1, "_addSuper", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(BoxInterface.class)), null, null);
        addSuper.visitCode();
        addSuper.visitFieldInsn(178, type.getInternalName(), "_supers", Type.getDescriptor(List.class));
        addSuper.visitVarInsn(25, 1);
        addSuper.visitMethodInsn(185, Type.getInternalName(List.class), "add", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.getType(Object.class)), true);
        addSuper.visitInsn(87);
        addSuper.visitInsn(177);
        addSuper.visitMaxs(0, 0);
        addSuper.visitEnd();
        classNode.visitField(25, "keys", Type.getDescriptor(Key[].class), null, null).visitEnd();
        AsmHelper.addPrviateStaticFieldGetter(classNode, type, "abstractMethods", "getAbstractMethods", Type.getType(Map.class), null);
        AsmHelper.addPrviateStaticFieldGetter(classNode, type, "defaultMethods", "getDefaultMethods", Type.getType(Map.class), null);
        Label start = new Label();
        Label end = new Label();
        Label handler = new Label();
        MethodVisitor pseudoConstructor = classNode.visitMethod(1, "pseudoConstructor", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class)), null, null);
        pseudoConstructor.visitTryCatchBlock(start, end, handler, null);
        pseudoConstructor.visitCode();
        pseudoConstructor.visitVarInsn(25, 1);
        pseudoConstructor.visitVarInsn(25, 0);
        pseudoConstructor.visitMethodInsn(185, Type.getInternalName(IBoxContext.class), "pushTemplate", Type.getMethodDescriptor(Type.getType(IBoxContext.class), Type.getType(IBoxRunnable.class)), true);
        pseudoConstructor.visitInsn(87);
        pseudoConstructor.visitLabel(start);
        pseudoConstructor.visitVarInsn(25, 0);
        pseudoConstructor.visitVarInsn(25, 1);
        pseudoConstructor.visitMethodInsn(182, type.getInternalName(), "_pseudoConstructor", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class)), false);
        pseudoConstructor.visitLabel(end);
        pseudoConstructor.visitVarInsn(25, 1);
        pseudoConstructor.visitMethodInsn(185, Type.getInternalName(IBoxContext.class), "popTemplate", Type.getMethodDescriptor(Type.getType(ResolvedFilePath.class), new Type[0]), true);
        pseudoConstructor.visitInsn(87);
        pseudoConstructor.visitInsn(177);
        pseudoConstructor.visitLabel(handler);
        pseudoConstructor.visitVarInsn(25, 1);
        pseudoConstructor.visitMethodInsn(185, Type.getInternalName(IBoxContext.class), "popTemplate", Type.getMethodDescriptor(Type.getType(ResolvedFilePath.class), new Type[0]), true);
        pseudoConstructor.visitInsn(87);
        pseudoConstructor.visitInsn(191);
        pseudoConstructor.visitMaxs(0, 0);
        pseudoConstructor.visitEnd();
        ArrayList<List<AbstractInsnNode>> imports = new ArrayList<List<AbstractInsnNode>>();
        for (BoxImport statement : boxInterface.getImports()) {
            imports.add(transpiler.transform(statement, TransformerContext.NONE, ReturnValueContext.EMPTY));
        }
        List<AbstractInsnNode> importNodes = AsmHelper.array(Type.getType(ImportDefinition.class), Stream.concat(imports.stream(), transpiler.getImports().stream().map(raw -> {
            ArrayList<MethodInsnNode> nodes = new ArrayList<MethodInsnNode>();
            nodes.addAll((Collection<MethodInsnNode>)raw);
            nodes.add(new MethodInsnNode(184, Type.getInternalName(ImportDefinition.class), "parse", Type.getMethodDescriptor(Type.getType(ImportDefinition.class), Type.getType(String.class)), false));
            return nodes;
        })).filter(l -> l.size() > 0).toList());
        AsmHelper.methodWithContextAndClassLocator(classNode, "_pseudoConstructor", Type.getType(IBoxContext.class), Type.VOID_TYPE, false, transpiler, false, () -> boxInterface.getBody().stream().sorted((a, b) -> {
            if (a instanceof BoxFunctionDeclaration && !(b instanceof BoxFunctionDeclaration)) {
                return -1;
            }
            if (b instanceof BoxFunctionDeclaration && !(a instanceof BoxFunctionDeclaration)) {
                return 1;
            }
            return 0;
        }).flatMap(statement -> {
            BoxFunctionDeclaration bfd;
            if (!(statement instanceof BoxFunctionDeclaration || statement instanceof BoxImport || statement instanceof BoxStaticInitializer)) {
                throw new ExpressionException("Statement type not supported in an interface: " + statement.getClass().getSimpleName(), (BoxNode)statement);
            }
            if (statement instanceof BoxFunctionDeclaration && (bfd = (BoxFunctionDeclaration)statement).getBody() == null) {
                return new ArrayList().stream();
            }
            return transpiler.transform((BoxNode)statement, TransformerContext.NONE, ReturnValueContext.EMPTY).stream();
        }).toList());
        AsmHelper.methodWithContextAndClassLocator(classNode, "staticInitializer", Type.getType(IBoxContext.class), Type.VOID_TYPE, true, transpiler, false, () -> {
            ArrayList staticNodes = new ArrayList();
            boxInterface.getDescendantsOfType(BoxFunctionDeclaration.class, expr -> {
                BoxFunctionDeclaration func = expr;
                return func.getModifiers().contains((Object)BoxMethodDeclarationModifier.STATIC);
            }).forEach(func -> staticNodes.addAll(transpiler.transform((BoxNode)func, TransformerContext.NONE)));
            staticNodes.addAll(transpiler.getBoxStaticInitializers().stream().map(staticInitializer -> {
                if (staticInitializer == null || staticInitializer.getBody().size() == 0) {
                    return new ArrayList();
                }
                return staticInitializer.getBody().stream().map(statement -> transpiler.transform((BoxNode)statement, TransformerContext.NONE)).flatMap(nodes -> nodes.stream()).collect(Collectors.toList());
            }).flatMap(s -> s.stream()).collect(Collectors.toList()));
            return staticNodes;
        });
        AsmHelper.complete(classNode, type, methodVisitor -> {
            AsmHelper.resolvedFilePath(methodVisitor, mappingName, mappingPath, relativePath, filePath);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "path", Type.getDescriptor(ResolvedFilePath.class));
            methodVisitor.visitFieldInsn(178, Type.getInternalName(BoxSourceType.class), sourceType, Type.getDescriptor(BoxSourceType.class));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "sourceType", Type.getDescriptor(BoxSourceType.class));
            List<AbstractInsnNode> annotations = transpiler.transformAnnotations(boxInterface.getAllAnnotations());
            List<AbstractInsnNode> documenation = transpiler.transformDocumentation(boxInterface.getDocumentation());
            List<AbstractInsnNode> name = transpiler.createKey(boxInterfacename);
            List<AbstractInsnNode> abstractMethods = AsmHelper.generateMapOfAbstractMethodNames(transpiler, boxInterface);
            methodVisitor.visitLdcInsn(transpiler.getKeys().size());
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Key.class));
            int index = 0;
            for (BoxExpression expression : transpiler.getKeys().values()) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn(index++);
                transpiler.transform(expression, TransformerContext.NONE, ReturnValueContext.EMPTY).forEach(methodInsnNode -> methodInsnNode.accept((MethodVisitor)methodVisitor));
                methodVisitor.visitMethodInsn(184, Type.getInternalName(Key.class), "of", Type.getMethodDescriptor(Type.getType(Key.class), Type.getType(Object.class)), false);
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "keys", Type.getDescriptor(Key[].class));
            name.forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "name", Type.getDescriptor(Key.class));
            importNodes.forEach(node -> node.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitMethodInsn(184, Type.getInternalName(List.class), "of", Type.getMethodDescriptor(Type.getType(List.class), Type.getType(Object[].class)), true);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "imports", Type.getDescriptor(List.class));
            annotations.forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "annotations", Type.getDescriptor(IStruct.class));
            documenation.forEach(abstractInsnNode -> abstractInsnNode.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "documentation", Type.getDescriptor(IStruct.class));
            methodVisitor.visitTypeInsn(187, Type.getInternalName(LinkedHashMap.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(LinkedHashMap.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "abstractMethods", Type.getDescriptor(Map.class));
            methodVisitor.visitTypeInsn(187, Type.getInternalName(LinkedHashMap.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(LinkedHashMap.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "defaultMethods", Type.getDescriptor(Map.class));
            methodVisitor.visitTypeInsn(187, Type.getInternalName(ArrayList.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(ArrayList.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), false);
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "_supers", Type.getDescriptor(List.class));
            abstractMethods.forEach(node -> node.accept((MethodVisitor)methodVisitor));
            methodVisitor.visitFieldInsn(179, type.getInternalName(), "abstractMethods", Type.getDescriptor(Map.class));
        });
        return classNode;
    }
}

