/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxThrow;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.CustomException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;

public class BoxThrowTransformer
extends AbstractTransformer {
    public BoxThrowTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        BoxThrow boxThrow = (BoxThrow)node;
        nodes.addAll(this.getNewCustomExceptionInstructions(boxThrow));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(ExceptionUtil.class), "throwException", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(Object.class)), false));
        nodes.add(new InsnNode(1));
        return nodes;
    }

    private List<AbstractInsnNode> getNewCustomExceptionInstructions(BoxThrow boxThrow) {
        BoxExpression object = boxThrow.getExpression();
        BoxExpression type = boxThrow.getType();
        BoxExpression message = boxThrow.getMessage();
        BoxExpression detail = boxThrow.getDetail();
        BoxExpression errorcode = boxThrow.getErrorCode();
        BoxExpression extendedinfo = boxThrow.getExtendedInfo();
        if (message == null && object == null) {
            return List.of(new TypeInsnNode(187, Type.getInternalName(CustomException.class)), new InsnNode(89), new InsnNode(1), new MethodInsnNode(183, Type.getInternalName(CustomException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class)), false));
        }
        if (message == null) {
            return this.transpiler.transform(boxThrow.getExpression(), TransformerContext.RIGHT);
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.add(new TypeInsnNode(187, Type.getInternalName(CustomException.class)));
        nodes.add(new InsnNode(89));
        nodes.addAll(this.transpiler.transform(message, null));
        nodes.addAll(this.nullGuard(detail));
        nodes.addAll(this.nullGuard(errorcode));
        nodes.addAll(this.nullGuard(type));
        if (extendedinfo == null) {
            nodes.add(new InsnNode(1));
        } else {
            nodes.addAll(this.transpiler.transform(extendedinfo, null));
        }
        if (object == null) {
            nodes.add(new InsnNode(1));
        } else {
            nodes.addAll(this.transpiler.transform(boxThrow.getExpression(), TransformerContext.RIGHT));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(DynamicObject.class), "unWrap", Type.getMethodDescriptor(Type.getType(Object.class), Type.getType(Object.class)), false));
        }
        nodes.add(new MethodInsnNode(183, Type.getInternalName(CustomException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object.class), Type.getType(Throwable.class)), false));
        return nodes;
    }

    private List<AbstractInsnNode> nullGuard(BoxExpression expr) {
        if (expr == null) {
            return List.of(new InsnNode(1));
        }
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        nodes.addAll(this.transpiler.transform(expr, null));
        LabelNode ifNullLabel = new LabelNode();
        nodes.add(new JumpInsnNode(198, ifNullLabel));
        nodes.add(new InsnNode(1));
        LabelNode elseLabel = new LabelNode();
        nodes.add(new JumpInsnNode(167, elseLabel));
        nodes.add(ifNullLabel);
        nodes.addAll(this.transpiler.transform(expr, null));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(StringCaster.class), "cast", Type.getMethodDescriptor(Type.getType(String.class), Type.getType(Object.class)), false));
        nodes.add(elseLabel);
        return nodes;
    }
}

