/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import ortus.boxlang.compiler.asmboxpiler.AsmHelper;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.runtime.context.CatchBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;

public class BoxTryTransformer
extends AbstractTransformer {
    public BoxTryTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnValueContext) {
        Optional<MethodContextTracker> trackerOption = this.transpiler.getCurrentMethodContextTracker();
        if (trackerOption.isEmpty()) {
            throw new IllegalStateException();
        }
        MethodContextTracker tracker = trackerOption.get();
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        BoxTry boxTry = (BoxTry)node;
        LabelNode tryStartLabel = new LabelNode();
        LabelNode tryEndLabel = new LabelNode();
        LabelNode finallyStartLabel = new LabelNode();
        LabelNode finallyEndLabel = new LabelNode();
        nodes.add(tryStartLabel);
        nodes.addAll(this.generateBodyNodesWithInlinedFinally(context, returnValueContext, boxTry.getTryBody(), boxTry.getFinallyBody(), () -> tryEndLabel));
        nodes.add(new JumpInsnNode(167, finallyEndLabel));
        if (boxTry.getCatches().size() > 0) {
            LabelNode javaCatchBodyStart = new LabelNode();
            nodes.add(javaCatchBodyStart);
            MethodContextTracker.VarStore eVar = tracker.storeNewVariable(58);
            nodes.addAll(eVar.nodes());
            for (BoxTryCatch catchNode : boxTry.getCatches()) {
                nodes.addAll(this.generateCatchBodyNodes(context, returnValueContext, tracker, boxTry, catchNode, finallyStartLabel, finallyEndLabel, eVar.index()));
            }
            TryCatchBlockNode catchHandler = new TryCatchBlockNode(tryStartLabel, tryEndLabel, javaCatchBodyStart, null);
            tracker.addTryCatchBlock(catchHandler);
            if (boxTry.getFinallyBody().size() == 0) {
                nodes.add(new InsnNode(1));
                if (returnValueContext != ReturnValueContext.VALUE_OR_NULL) {
                    nodes.add(new InsnNode(87));
                }
            }
            nodes.addAll(AsmHelper.transformBodyExpressions(this.transpiler, boxTry.getFinallyBody(), context, returnValueContext));
            nodes.add(new JumpInsnNode(167, finallyEndLabel));
        }
        TryCatchBlockNode catchHandler = new TryCatchBlockNode(tryStartLabel, tryEndLabel, finallyStartLabel, null);
        tracker.addTryCatchBlock(catchHandler);
        nodes.add(finallyStartLabel);
        MethodContextTracker.VarStore errorVarStore = tracker.storeNewVariable(58);
        nodes.addAll(errorVarStore.nodes());
        nodes.addAll(AsmHelper.transformBodyExpressions(this.transpiler, boxTry.getFinallyBody(), context, returnValueContext));
        nodes.add(new VarInsnNode(25, errorVarStore.index()));
        nodes.add(new InsnNode(191));
        nodes.add(finallyEndLabel);
        tracker.addTryCatchBlock(new TryCatchBlockNode(tryStartLabel, tryEndLabel, finallyStartLabel, null));
        return nodes;
    }

    private List<AbstractInsnNode> generateBodyNodesWithInlinedFinally(TransformerContext context, ReturnValueContext returnValueContext, List<BoxStatement> codeBody, List<BoxStatement> finallyBody, Supplier<AbstractInsnNode> inBetween) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        if (codeBody.size() == 0 && finallyBody.size() == 0) {
            AbstractInsnNode inBetweenNode;
            nodes.add(new InsnNode(1));
            if (returnValueContext != ReturnValueContext.VALUE_OR_NULL) {
                nodes.add(new InsnNode(87));
            }
            if ((inBetweenNode = inBetween.get()) != null) {
                nodes.add(inBetweenNode);
            }
            return nodes;
        }
        nodes.addAll(AsmHelper.transformBodyExpressions(this.transpiler, codeBody, context, finallyBody.size() > 0 ? ReturnValueContext.EMPTY : returnValueContext));
        AbstractInsnNode inBetweenNode = inBetween.get();
        if (inBetweenNode != null) {
            nodes.add(inBetweenNode);
        }
        nodes.addAll(AsmHelper.transformBodyExpressions(this.transpiler, finallyBody, context, returnValueContext));
        return nodes;
    }

    private List<AbstractInsnNode> generateCatchBodyNodes(TransformerContext context, ReturnValueContext returnValueContext, MethodContextTracker tracker, BoxTry boxTry, BoxTryCatch boxCatch, LabelNode finallyStartLabel, LabelNode finallyEndLabel, int eVarIndex) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        LabelNode startHandlerLabel = new LabelNode();
        LabelNode endHandlerLabel = new LabelNode();
        nodes.addAll(this.generateCatchIfGuard(context, boxCatch.getCatchTypes(), tracker, startHandlerLabel, endHandlerLabel, eVarIndex));
        nodes.add(startHandlerLabel);
        nodes.add(new TypeInsnNode(187, Type.getInternalName(CatchBoxContext.class)));
        nodes.add(new InsnNode(89));
        nodes.addAll(tracker.loadCurrentContext());
        nodes.addAll(this.transpiler.createKey(boxCatch.getException().getName()));
        nodes.add(new VarInsnNode(25, eVarIndex));
        nodes.add(new MethodInsnNode(183, Type.getInternalName(CatchBoxContext.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(IBoxContext.class), Type.getType(Key.class), Type.getType(Throwable.class)), false));
        nodes.addAll(tracker.trackNewContext());
        nodes.addAll(this.generateBodyNodesWithInlinedFinally(context, returnValueContext, boxCatch.getCatchBody(), boxTry.getFinallyBody(), () -> {
            tracker.popContext();
            return null;
        }));
        nodes.add(new JumpInsnNode(167, finallyEndLabel));
        nodes.add(endHandlerLabel);
        tracker.addTryCatchBlock(new TryCatchBlockNode(startHandlerLabel, endHandlerLabel, finallyStartLabel, null));
        return nodes;
    }

    private List<AbstractInsnNode> generateCatchIfGuard(TransformerContext context, List<BoxExpression> catchTypes, MethodContextTracker tracker, LabelNode startHandlerLabel, LabelNode endHandlerLabel, int eVarIndex) {
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        if (catchTypes.size() == 0) {
            return new ArrayList<AbstractInsnNode>();
        }
        for (int i = 0; i < catchTypes.size() - 1; ++i) {
            nodes.add(new VarInsnNode(25, eVarIndex));
            nodes.addAll(tracker.loadCurrentContext());
            nodes.add(new InsnNode(95));
            nodes.addAll(this.transpiler.transform(catchTypes.get(i), context, ReturnValueContext.VALUE));
            nodes.add(new MethodInsnNode(184, Type.getInternalName(ExceptionUtil.class), "exceptionIsOfType", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(IBoxContext.class), Type.getType(Throwable.class), Type.getType(String.class)), false));
            nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
            nodes.add(new JumpInsnNode(154, startHandlerLabel));
        }
        nodes.add(new VarInsnNode(25, eVarIndex));
        nodes.addAll(tracker.loadCurrentContext());
        nodes.add(new InsnNode(95));
        nodes.addAll(this.transpiler.transform(catchTypes.getLast(), context, ReturnValueContext.VALUE));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(ExceptionUtil.class), "exceptionIsOfType", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(IBoxContext.class), Type.getType(Throwable.class), Type.getType(String.class)), false));
        nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
        nodes.add(new JumpInsnNode(153, endHandlerLabel));
        return nodes;
    }
}

