/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.asmboxpiler.transformer.statement;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import ortus.boxlang.compiler.asmboxpiler.MethodContextTracker;
import ortus.boxlang.compiler.asmboxpiler.Transpiler;
import ortus.boxlang.compiler.asmboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.asmboxpiler.transformer.ReturnValueContext;
import ortus.boxlang.compiler.asmboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;

public class BoxWhileTransformer
extends AbstractTransformer {
    public BoxWhileTransformer(Transpiler transpiler) {
        super(transpiler);
    }

    @Override
    public List<AbstractInsnNode> transform(BoxNode node, TransformerContext context, ReturnValueContext returnContext) throws IllegalStateException {
        BoxWhile boxWhile = (BoxWhile)node;
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        LabelNode breakTarget = new LabelNode();
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
        MethodContextTracker tracker = this.transpiler.getCurrentMethodContextTracker().get();
        tracker.setBreak(boxWhile, breakTarget);
        tracker.setContinue(boxWhile, start);
        if (boxWhile.getLabel() != null) {
            tracker.setStringLabel(boxWhile.getLabel(), boxWhile);
        }
        if (returnContext == ReturnValueContext.VALUE_OR_NULL) {
            nodes.add(new InsnNode(1));
            nodes.add(new InsnNode(1));
        }
        nodes.add(start);
        if (returnContext == ReturnValueContext.VALUE_OR_NULL) {
            nodes.add(new InsnNode(95));
            nodes.add(new InsnNode(87));
        }
        nodes.addAll(this.transpiler.transform(boxWhile.getCondition(), TransformerContext.RIGHT, ReturnValueContext.VALUE));
        nodes.add(new MethodInsnNode(184, Type.getInternalName(BooleanCaster.class), "cast", Type.getMethodDescriptor(Type.getType(Boolean.class), Type.getType(Object.class)), false));
        nodes.add(new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
        nodes.add(new JumpInsnNode(153, end));
        nodes.addAll(this.transpiler.transform(boxWhile.getBody(), TransformerContext.NONE, returnContext));
        nodes.add(new JumpInsnNode(167, start));
        nodes.add(breakTarget);
        if (returnContext == ReturnValueContext.VALUE_OR_NULL) {
            nodes.add(new InsnNode(95));
            nodes.add(new InsnNode(87));
        }
        nodes.add(end);
        return nodes;
    }
}

